// Generated by rstantools.  Do not edit by hand.

/*
    measr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    measr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with measr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by %%NAME%% %%VERSION%%
#include <stan/model/model_header.hpp>
namespace model_test_dina_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'test_dina', line 16, column 2 to column 16)",
                                                      " (in 'test_dina', line 18, column 2 to column 32)",
                                                      " (in 'test_dina', line 19, column 2 to column 33)",
                                                      " (in 'test_dina', line 22, column 2 to column 29)",
                                                      " (in 'test_dina', line 23, column 2 to column 17)",
                                                      " (in 'test_dina', line 26, column 6 to column 71)",
                                                      " (in 'test_dina', line 25, column 19 to line 27, column 5)",
                                                      " (in 'test_dina', line 25, column 4 to line 27, column 5)",
                                                      " (in 'test_dina', line 24, column 17 to line 28, column 3)",
                                                      " (in 'test_dina', line 24, column 2 to line 28, column 3)",
                                                      " (in 'test_dina', line 31, column 10 to column 11)",
                                                      " (in 'test_dina', line 31, column 2 to column 13)",
                                                      " (in 'test_dina', line 33, column 2 to column 24)",
                                                      " (in 'test_dina', line 34, column 2 to column 25)",
                                                      " (in 'test_dina', line 35, column 2 to column 24)",
                                                      " (in 'test_dina', line 36, column 2 to column 25)",
                                                      " (in 'test_dina', line 37, column 2 to column 24)",
                                                      " (in 'test_dina', line 38, column 2 to column 25)",
                                                      " (in 'test_dina', line 39, column 2 to column 24)",
                                                      " (in 'test_dina', line 40, column 2 to column 25)",
                                                      " (in 'test_dina', line 41, column 2 to column 24)",
                                                      " (in 'test_dina', line 42, column 2 to column 25)",
                                                      " (in 'test_dina', line 43, column 2 to column 24)",
                                                      " (in 'test_dina', line 44, column 2 to column 25)",
                                                      " (in 'test_dina', line 45, column 2 to column 24)",
                                                      " (in 'test_dina', line 46, column 2 to column 25)",
                                                      " (in 'test_dina', line 47, column 2 to column 24)",
                                                      " (in 'test_dina', line 48, column 2 to column 25)",
                                                      " (in 'test_dina', line 49, column 2 to column 24)",
                                                      " (in 'test_dina', line 50, column 2 to column 25)",
                                                      " (in 'test_dina', line 51, column 2 to column 25)",
                                                      " (in 'test_dina', line 52, column 2 to column 26)",
                                                      " (in 'test_dina', line 53, column 2 to column 25)",
                                                      " (in 'test_dina', line 54, column 2 to column 26)",
                                                      " (in 'test_dina', line 55, column 2 to column 25)",
                                                      " (in 'test_dina', line 56, column 2 to column 26)",
                                                      " (in 'test_dina', line 57, column 2 to column 25)",
                                                      " (in 'test_dina', line 58, column 2 to column 26)",
                                                      " (in 'test_dina', line 59, column 2 to column 25)",
                                                      " (in 'test_dina', line 60, column 2 to column 26)",
                                                      " (in 'test_dina', line 61, column 2 to column 25)",
                                                      " (in 'test_dina', line 62, column 2 to column 26)",
                                                      " (in 'test_dina', line 63, column 2 to column 25)",
                                                      " (in 'test_dina', line 64, column 2 to column 26)",
                                                      " (in 'test_dina', line 65, column 2 to column 25)",
                                                      " (in 'test_dina', line 66, column 2 to column 26)",
                                                      " (in 'test_dina', line 67, column 2 to column 25)",
                                                      " (in 'test_dina', line 68, column 2 to column 26)",
                                                      " (in 'test_dina', line 69, column 2 to column 25)",
                                                      " (in 'test_dina', line 70, column 2 to column 26)",
                                                      " (in 'test_dina', line 71, column 2 to column 25)",
                                                      " (in 'test_dina', line 72, column 2 to column 26)",
                                                      " (in 'test_dina', line 73, column 2 to column 25)",
                                                      " (in 'test_dina', line 74, column 2 to column 26)",
                                                      " (in 'test_dina', line 75, column 2 to column 25)",
                                                      " (in 'test_dina', line 76, column 2 to column 26)",
                                                      " (in 'test_dina', line 77, column 2 to column 25)",
                                                      " (in 'test_dina', line 78, column 2 to column 26)",
                                                      " (in 'test_dina', line 79, column 2 to column 25)",
                                                      " (in 'test_dina', line 80, column 2 to column 26)",
                                                      " (in 'test_dina', line 81, column 2 to column 25)",
                                                      " (in 'test_dina', line 82, column 2 to column 26)",
                                                      " (in 'test_dina', line 83, column 2 to column 25)",
                                                      " (in 'test_dina', line 84, column 2 to column 26)",
                                                      " (in 'test_dina', line 85, column 2 to column 25)",
                                                      " (in 'test_dina', line 86, column 2 to column 26)",
                                                      " (in 'test_dina', line 87, column 2 to column 25)",
                                                      " (in 'test_dina', line 88, column 2 to column 26)",
                                                      " (in 'test_dina', line 89, column 2 to column 25)",
                                                      " (in 'test_dina', line 90, column 2 to column 26)",
                                                      " (in 'test_dina', line 91, column 2 to column 25)",
                                                      " (in 'test_dina', line 92, column 2 to column 26)",
                                                      " (in 'test_dina', line 93, column 2 to column 25)",
                                                      " (in 'test_dina', line 94, column 2 to column 26)",
                                                      " (in 'test_dina', line 95, column 2 to column 25)",
                                                      " (in 'test_dina', line 96, column 2 to column 26)",
                                                      " (in 'test_dina', line 97, column 2 to column 25)",
                                                      " (in 'test_dina', line 98, column 2 to column 26)",
                                                      " (in 'test_dina', line 99, column 2 to column 25)",
                                                      " (in 'test_dina', line 100, column 2 to column 26)",
                                                      " (in 'test_dina', line 101, column 2 to column 25)",
                                                      " (in 'test_dina', line 102, column 2 to column 26)",
                                                      " (in 'test_dina', line 106, column 21 to column 27)",
                                                      " (in 'test_dina', line 106, column 6 to column 29)",
                                                      " (in 'test_dina', line 108, column 8 to column 37)",
                                                      " (in 'test_dina', line 109, column 8 to line 110, column 68)",
                                                      " (in 'test_dina', line 107, column 26 to line 111, column 7)",
                                                      " (in 'test_dina', line 107, column 6 to line 111, column 7)",
                                                      " (in 'test_dina', line 112, column 6 to column 41)",
                                                      " (in 'test_dina', line 105, column 19 to line 113, column 5)",
                                                      " (in 'test_dina', line 105, column 4 to line 113, column 5)",
                                                      " (in 'test_dina', line 114, column 4 to column 30)",
                                                      " (in 'test_dina', line 104, column 17 to line 115, column 3)",
                                                      " (in 'test_dina', line 104, column 2 to line 115, column 3)",
                                                      " (in 'test_dina', line 2, column 2 to column 17)",
                                                      " (in 'test_dina', line 3, column 2 to column 17)",
                                                      " (in 'test_dina', line 4, column 2 to column 17)",
                                                      " (in 'test_dina', line 5, column 2 to column 17)",
                                                      " (in 'test_dina', line 6, column 2 to column 17)",
                                                      " (in 'test_dina', line 7, column 26 to column 27)",
                                                      " (in 'test_dina', line 7, column 2 to column 29)",
                                                      " (in 'test_dina', line 8, column 26 to column 27)",
                                                      " (in 'test_dina', line 8, column 2 to column 29)",
                                                      " (in 'test_dina', line 9, column 25 to column 26)",
                                                      " (in 'test_dina', line 9, column 2 to column 28)",
                                                      " (in 'test_dina', line 10, column 29 to column 30)",
                                                      " (in 'test_dina', line 10, column 2 to column 32)",
                                                      " (in 'test_dina', line 11, column 27 to column 28)",
                                                      " (in 'test_dina', line 11, column 2 to column 30)",
                                                      " (in 'test_dina', line 12, column 9 to column 10)",
                                                      " (in 'test_dina', line 12, column 11 to column 12)",
                                                      " (in 'test_dina', line 12, column 2 to column 20)",
                                                      " (in 'test_dina', line 13, column 9 to column 10)",
                                                      " (in 'test_dina', line 13, column 11 to column 12)",
                                                      " (in 'test_dina', line 13, column 2 to column 17)",
                                                      " (in 'test_dina', line 16, column 10 to column 11)",
                                                      " (in 'test_dina', line 18, column 29 to column 30)",
                                                      " (in 'test_dina', line 19, column 30 to column 31)",
                                                      " (in 'test_dina', line 22, column 9 to column 10)",
                                                      " (in 'test_dina', line 23, column 9 to column 10)",
                                                      " (in 'test_dina', line 23, column 11 to column 12)"};
#include <stan_meta_header.hpp>
class model_test_dina final : public model_base_crtp<model_test_dina> {
private:
  int I;
  int R;
  int N;
  int C;
  int A;
  std::vector<int> ii;
  std::vector<int> rr;
  std::vector<int> y;
  std::vector<int> start;
  std::vector<int> num;
  Eigen::Matrix<double, -1, -1> Alpha;
  Eigen::Matrix<double, -1, -1> Xi;
 
public:
  ~model_test_dina() { }
  
  inline std::string model_name() const final { return "model_test_dina"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = %%NAME%%3 %%VERSION%%", "stancflags = "};
  }
  
  
  model_test_dina(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_test_dina_namespace::model_test_dina";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 95;
      context__.validate_dims("data initialization","I","int",
          context__.to_vec());
      I = std::numeric_limits<int>::min();
      
      current_statement__ = 95;
      I = context__.vals_i("I")[(1 - 1)];
      current_statement__ = 95;
      current_statement__ = 95;
      check_greater_or_equal(function__, "I", I, 1);
      current_statement__ = 96;
      context__.validate_dims("data initialization","R","int",
          context__.to_vec());
      R = std::numeric_limits<int>::min();
      
      current_statement__ = 96;
      R = context__.vals_i("R")[(1 - 1)];
      current_statement__ = 96;
      current_statement__ = 96;
      check_greater_or_equal(function__, "R", R, 1);
      current_statement__ = 97;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 97;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 97;
      current_statement__ = 97;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 98;
      context__.validate_dims("data initialization","C","int",
          context__.to_vec());
      C = std::numeric_limits<int>::min();
      
      current_statement__ = 98;
      C = context__.vals_i("C")[(1 - 1)];
      current_statement__ = 98;
      current_statement__ = 98;
      check_greater_or_equal(function__, "C", C, 1);
      current_statement__ = 99;
      context__.validate_dims("data initialization","A","int",
          context__.to_vec());
      A = std::numeric_limits<int>::min();
      
      current_statement__ = 99;
      A = context__.vals_i("A")[(1 - 1)];
      current_statement__ = 99;
      current_statement__ = 99;
      check_greater_or_equal(function__, "A", A, 1);
      current_statement__ = 100;
      validate_non_negative_index("ii", "N", N);
      current_statement__ = 101;
      context__.validate_dims("data initialization","ii","int",
          context__.to_vec(N));
      ii = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 101;
      assign(ii, nil_index_list(), context__.vals_i("ii"),
        "assigning variable ii");
      current_statement__ = 101;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 101;
        current_statement__ = 101;
        check_greater_or_equal(function__, "ii[sym1__]", ii[(sym1__ - 1)], 1);
      }
      current_statement__ = 101;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 101;
        current_statement__ = 101;
        check_less_or_equal(function__, "ii[sym1__]", ii[(sym1__ - 1)], I);}
      current_statement__ = 102;
      validate_non_negative_index("rr", "N", N);
      current_statement__ = 103;
      context__.validate_dims("data initialization","rr","int",
          context__.to_vec(N));
      rr = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 103;
      assign(rr, nil_index_list(), context__.vals_i("rr"),
        "assigning variable rr");
      current_statement__ = 103;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 103;
        current_statement__ = 103;
        check_greater_or_equal(function__, "rr[sym1__]", rr[(sym1__ - 1)], 1);
      }
      current_statement__ = 103;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 103;
        current_statement__ = 103;
        check_less_or_equal(function__, "rr[sym1__]", rr[(sym1__ - 1)], R);}
      current_statement__ = 104;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 105;
      context__.validate_dims("data initialization","y","int",
          context__.to_vec(N));
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 105;
      assign(y, nil_index_list(), context__.vals_i("y"),
        "assigning variable y");
      current_statement__ = 105;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 105;
        current_statement__ = 105;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 105;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 105;
        current_statement__ = 105;
        check_less_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 1);}
      current_statement__ = 106;
      validate_non_negative_index("start", "R", R);
      current_statement__ = 107;
      context__.validate_dims("data initialization","start","int",
          context__.to_vec(R));
      start = std::vector<int>(R, std::numeric_limits<int>::min());
      
      current_statement__ = 107;
      assign(start, nil_index_list(), context__.vals_i("start"),
        "assigning variable start");
      current_statement__ = 107;
      for (int sym1__ = 1; sym1__ <= R; ++sym1__) {
        current_statement__ = 107;
        current_statement__ = 107;
        check_greater_or_equal(function__, "start[sym1__]",
                               start[(sym1__ - 1)], 1);}
      current_statement__ = 107;
      for (int sym1__ = 1; sym1__ <= R; ++sym1__) {
        current_statement__ = 107;
        current_statement__ = 107;
        check_less_or_equal(function__, "start[sym1__]", start[(sym1__ - 1)],
                            N);}
      current_statement__ = 108;
      validate_non_negative_index("num", "R", R);
      current_statement__ = 109;
      context__.validate_dims("data initialization","num","int",
          context__.to_vec(R));
      num = std::vector<int>(R, std::numeric_limits<int>::min());
      
      current_statement__ = 109;
      assign(num, nil_index_list(), context__.vals_i("num"),
        "assigning variable num");
      current_statement__ = 109;
      for (int sym1__ = 1; sym1__ <= R; ++sym1__) {
        current_statement__ = 109;
        current_statement__ = 109;
        check_greater_or_equal(function__, "num[sym1__]", num[(sym1__ - 1)],
                               1);}
      current_statement__ = 109;
      for (int sym1__ = 1; sym1__ <= R; ++sym1__) {
        current_statement__ = 109;
        current_statement__ = 109;
        check_less_or_equal(function__, "num[sym1__]", num[(sym1__ - 1)], I);
      }
      current_statement__ = 110;
      validate_non_negative_index("Alpha", "C", C);
      current_statement__ = 111;
      validate_non_negative_index("Alpha", "A", A);
      current_statement__ = 112;
      context__.validate_dims("data initialization","Alpha","double",
          context__.to_vec(C, A));
      Alpha = Eigen::Matrix<double, -1, -1>(C, A);
      stan::math::fill(Alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Alpha_flat__;
        current_statement__ = 112;
        assign(Alpha_flat__, nil_index_list(), context__.vals_r("Alpha"),
          "assigning variable Alpha_flat__");
        current_statement__ = 112;
        pos__ = 1;
        current_statement__ = 112;
        for (int sym1__ = 1; sym1__ <= A; ++sym1__) {
          current_statement__ = 112;
          for (int sym2__ = 1; sym2__ <= C; ++sym2__) {
            current_statement__ = 112;
            assign(Alpha,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Alpha_flat__[(pos__ - 1)], "assigning variable Alpha");
            current_statement__ = 112;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 113;
      validate_non_negative_index("Xi", "I", I);
      current_statement__ = 114;
      validate_non_negative_index("Xi", "C", C);
      current_statement__ = 115;
      context__.validate_dims("data initialization","Xi","double",
          context__.to_vec(I, C));
      Xi = Eigen::Matrix<double, -1, -1>(I, C);
      stan::math::fill(Xi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Xi_flat__;
        current_statement__ = 115;
        assign(Xi_flat__, nil_index_list(), context__.vals_r("Xi"),
          "assigning variable Xi_flat__");
        current_statement__ = 115;
        pos__ = 1;
        current_statement__ = 115;
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          current_statement__ = 115;
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            current_statement__ = 115;
            assign(Xi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Xi_flat__[(pos__ - 1)], "assigning variable Xi");
            current_statement__ = 115;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 116;
      validate_positive_index("Vc", "C", C);
      current_statement__ = 117;
      validate_non_negative_index("slip", "I", I);
      current_statement__ = 118;
      validate_non_negative_index("guess", "I", I);
      current_statement__ = 119;
      validate_non_negative_index("log_Vc", "C", C);
      current_statement__ = 120;
      validate_non_negative_index("pi", "I", I);
      current_statement__ = 121;
      validate_non_negative_index("pi", "C", C);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += (C - 1);
      num_params_r__ += I;
      num_params_r__ += I;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_test_dina_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> Vc;
      Vc = Eigen::Matrix<local_scalar_t__, -1, 1>(C);
      stan::math::fill(Vc, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> Vc_in__;
      Vc_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((C - 1));
      stan::math::fill(Vc_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      Vc_in__ = in__.vector((C - 1));
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        assign(Vc, nil_index_list(),
          stan::math::simplex_constrain(Vc_in__, lp__),
          "assigning variable Vc");
      } else {
        current_statement__ = 1;
        assign(Vc, nil_index_list(), stan::math::simplex_constrain(Vc_in__),
          "assigning variable Vc");
      }
      std::vector<local_scalar_t__> slip;
      slip = std::vector<local_scalar_t__>(I, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 2;
        assign(slip, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable slip");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(slip, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(slip[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable slip");
        } else {
          current_statement__ = 2;
          assign(slip, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(slip[(sym1__ - 1)], 0, 1),
            "assigning variable slip");
        }}
      std::vector<local_scalar_t__> guess;
      guess = std::vector<local_scalar_t__>(I, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 3;
        assign(guess, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable guess");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(guess, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(guess[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable guess");
        } else {
          current_statement__ = 3;
          assign(guess, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(guess[(sym1__ - 1)], 0, 1),
            "assigning variable guess");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> log_Vc;
      log_Vc = Eigen::Matrix<local_scalar_t__, -1, 1>(C);
      stan::math::fill(log_Vc, DUMMY_VAR__);
      
      current_statement__ = 4;
      assign(log_Vc, nil_index_list(), stan::math::log(Vc),
        "assigning variable log_Vc");
      Eigen::Matrix<local_scalar_t__, -1, -1> pi;
      pi = Eigen::Matrix<local_scalar_t__, -1, -1>(I, C);
      stan::math::fill(pi, DUMMY_VAR__);
      
      current_statement__ = 10;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 8;
        for (int c = 1; c <= C; ++c) {
          current_statement__ = 6;
          assign(pi,
            cons_list(index_uni(i),
              cons_list(index_uni(c), nil_index_list())),
            (pow((1 - slip[(i - 1)]),
               rvalue(Xi,
                 cons_list(index_uni(i),
                   cons_list(index_uni(c), nil_index_list())), "Xi")) *
              pow(guess[(i - 1)],
                (1 -
                  rvalue(Xi,
                    cons_list(index_uni(i),
                      cons_list(index_uni(c), nil_index_list())), "Xi")))),
            "assigning variable pi");}}
      {
        current_statement__ = 11;
        validate_non_negative_index("ps", "C", C);
        std::vector<local_scalar_t__> ps;
        ps = std::vector<local_scalar_t__>(C, DUMMY_VAR__);
        
        current_statement__ = 13;
        lp_accum__.add(beta_lpdf<propto__>(slip[(1 - 1)], 5, 25));
        current_statement__ = 14;
        lp_accum__.add(beta_lpdf<propto__>(guess[(1 - 1)], 5, 25));
        current_statement__ = 15;
        lp_accum__.add(beta_lpdf<propto__>(slip[(2 - 1)], 5, 25));
        current_statement__ = 16;
        lp_accum__.add(beta_lpdf<propto__>(guess[(2 - 1)], 5, 25));
        current_statement__ = 17;
        lp_accum__.add(beta_lpdf<propto__>(slip[(3 - 1)], 5, 25));
        current_statement__ = 18;
        lp_accum__.add(beta_lpdf<propto__>(guess[(3 - 1)], 5, 25));
        current_statement__ = 19;
        lp_accum__.add(beta_lpdf<propto__>(slip[(4 - 1)], 5, 25));
        current_statement__ = 20;
        lp_accum__.add(beta_lpdf<propto__>(guess[(4 - 1)], 5, 25));
        current_statement__ = 21;
        lp_accum__.add(beta_lpdf<propto__>(slip[(5 - 1)], 5, 25));
        current_statement__ = 22;
        lp_accum__.add(beta_lpdf<propto__>(guess[(5 - 1)], 5, 25));
        current_statement__ = 23;
        lp_accum__.add(beta_lpdf<propto__>(slip[(6 - 1)], 5, 25));
        current_statement__ = 24;
        lp_accum__.add(beta_lpdf<propto__>(guess[(6 - 1)], 5, 25));
        current_statement__ = 25;
        lp_accum__.add(beta_lpdf<propto__>(slip[(7 - 1)], 5, 25));
        current_statement__ = 26;
        lp_accum__.add(beta_lpdf<propto__>(guess[(7 - 1)], 5, 25));
        current_statement__ = 27;
        lp_accum__.add(beta_lpdf<propto__>(slip[(8 - 1)], 5, 25));
        current_statement__ = 28;
        lp_accum__.add(beta_lpdf<propto__>(guess[(8 - 1)], 5, 25));
        current_statement__ = 29;
        lp_accum__.add(beta_lpdf<propto__>(slip[(9 - 1)], 5, 25));
        current_statement__ = 30;
        lp_accum__.add(beta_lpdf<propto__>(guess[(9 - 1)], 5, 25));
        current_statement__ = 31;
        lp_accum__.add(beta_lpdf<propto__>(slip[(10 - 1)], 5, 25));
        current_statement__ = 32;
        lp_accum__.add(beta_lpdf<propto__>(guess[(10 - 1)], 5, 25));
        current_statement__ = 33;
        lp_accum__.add(beta_lpdf<propto__>(slip[(11 - 1)], 5, 25));
        current_statement__ = 34;
        lp_accum__.add(beta_lpdf<propto__>(guess[(11 - 1)], 5, 25));
        current_statement__ = 35;
        lp_accum__.add(beta_lpdf<propto__>(slip[(12 - 1)], 5, 25));
        current_statement__ = 36;
        lp_accum__.add(beta_lpdf<propto__>(guess[(12 - 1)], 5, 25));
        current_statement__ = 37;
        lp_accum__.add(beta_lpdf<propto__>(slip[(13 - 1)], 5, 25));
        current_statement__ = 38;
        lp_accum__.add(beta_lpdf<propto__>(guess[(13 - 1)], 5, 25));
        current_statement__ = 39;
        lp_accum__.add(beta_lpdf<propto__>(slip[(14 - 1)], 5, 25));
        current_statement__ = 40;
        lp_accum__.add(beta_lpdf<propto__>(guess[(14 - 1)], 5, 25));
        current_statement__ = 41;
        lp_accum__.add(beta_lpdf<propto__>(slip[(15 - 1)], 5, 25));
        current_statement__ = 42;
        lp_accum__.add(beta_lpdf<propto__>(guess[(15 - 1)], 5, 25));
        current_statement__ = 43;
        lp_accum__.add(beta_lpdf<propto__>(slip[(16 - 1)], 5, 25));
        current_statement__ = 44;
        lp_accum__.add(beta_lpdf<propto__>(guess[(16 - 1)], 5, 25));
        current_statement__ = 45;
        lp_accum__.add(beta_lpdf<propto__>(slip[(17 - 1)], 5, 25));
        current_statement__ = 46;
        lp_accum__.add(beta_lpdf<propto__>(guess[(17 - 1)], 5, 25));
        current_statement__ = 47;
        lp_accum__.add(beta_lpdf<propto__>(slip[(18 - 1)], 5, 25));
        current_statement__ = 48;
        lp_accum__.add(beta_lpdf<propto__>(guess[(18 - 1)], 5, 25));
        current_statement__ = 49;
        lp_accum__.add(beta_lpdf<propto__>(slip[(19 - 1)], 5, 25));
        current_statement__ = 50;
        lp_accum__.add(beta_lpdf<propto__>(guess[(19 - 1)], 5, 25));
        current_statement__ = 51;
        lp_accum__.add(beta_lpdf<propto__>(slip[(20 - 1)], 5, 25));
        current_statement__ = 52;
        lp_accum__.add(beta_lpdf<propto__>(guess[(20 - 1)], 5, 25));
        current_statement__ = 53;
        lp_accum__.add(beta_lpdf<propto__>(slip[(21 - 1)], 5, 25));
        current_statement__ = 54;
        lp_accum__.add(beta_lpdf<propto__>(guess[(21 - 1)], 5, 25));
        current_statement__ = 55;
        lp_accum__.add(beta_lpdf<propto__>(slip[(22 - 1)], 5, 25));
        current_statement__ = 56;
        lp_accum__.add(beta_lpdf<propto__>(guess[(22 - 1)], 5, 25));
        current_statement__ = 57;
        lp_accum__.add(beta_lpdf<propto__>(slip[(23 - 1)], 5, 25));
        current_statement__ = 58;
        lp_accum__.add(beta_lpdf<propto__>(guess[(23 - 1)], 5, 25));
        current_statement__ = 59;
        lp_accum__.add(beta_lpdf<propto__>(slip[(24 - 1)], 5, 25));
        current_statement__ = 60;
        lp_accum__.add(beta_lpdf<propto__>(guess[(24 - 1)], 5, 25));
        current_statement__ = 61;
        lp_accum__.add(beta_lpdf<propto__>(slip[(25 - 1)], 5, 25));
        current_statement__ = 62;
        lp_accum__.add(beta_lpdf<propto__>(guess[(25 - 1)], 5, 25));
        current_statement__ = 63;
        lp_accum__.add(beta_lpdf<propto__>(slip[(26 - 1)], 5, 25));
        current_statement__ = 64;
        lp_accum__.add(beta_lpdf<propto__>(guess[(26 - 1)], 5, 25));
        current_statement__ = 65;
        lp_accum__.add(beta_lpdf<propto__>(slip[(27 - 1)], 5, 25));
        current_statement__ = 66;
        lp_accum__.add(beta_lpdf<propto__>(guess[(27 - 1)], 5, 25));
        current_statement__ = 67;
        lp_accum__.add(beta_lpdf<propto__>(slip[(28 - 1)], 5, 25));
        current_statement__ = 68;
        lp_accum__.add(beta_lpdf<propto__>(guess[(28 - 1)], 5, 25));
        current_statement__ = 69;
        lp_accum__.add(beta_lpdf<propto__>(slip[(29 - 1)], 5, 25));
        current_statement__ = 70;
        lp_accum__.add(beta_lpdf<propto__>(guess[(29 - 1)], 5, 25));
        current_statement__ = 71;
        lp_accum__.add(beta_lpdf<propto__>(slip[(30 - 1)], 5, 25));
        current_statement__ = 72;
        lp_accum__.add(beta_lpdf<propto__>(guess[(30 - 1)], 5, 25));
        current_statement__ = 73;
        lp_accum__.add(beta_lpdf<propto__>(slip[(31 - 1)], 5, 25));
        current_statement__ = 74;
        lp_accum__.add(beta_lpdf<propto__>(guess[(31 - 1)], 5, 25));
        current_statement__ = 75;
        lp_accum__.add(beta_lpdf<propto__>(slip[(32 - 1)], 5, 25));
        current_statement__ = 76;
        lp_accum__.add(beta_lpdf<propto__>(guess[(32 - 1)], 5, 25));
        current_statement__ = 77;
        lp_accum__.add(beta_lpdf<propto__>(slip[(33 - 1)], 5, 25));
        current_statement__ = 78;
        lp_accum__.add(beta_lpdf<propto__>(guess[(33 - 1)], 5, 25));
        current_statement__ = 79;
        lp_accum__.add(beta_lpdf<propto__>(slip[(34 - 1)], 5, 25));
        current_statement__ = 80;
        lp_accum__.add(beta_lpdf<propto__>(guess[(34 - 1)], 5, 25));
        current_statement__ = 81;
        lp_accum__.add(beta_lpdf<propto__>(slip[(35 - 1)], 5, 25));
        current_statement__ = 82;
        lp_accum__.add(beta_lpdf<propto__>(guess[(35 - 1)], 5, 25));
        current_statement__ = 94;
        for (int r = 1; r <= R; ++r) {
          current_statement__ = 91;
          for (int c = 1; c <= C; ++c) {
            current_statement__ = 83;
            validate_non_negative_index("log_items", "num[r]", num[(r - 1)]);
            std::vector<local_scalar_t__> log_items;
            log_items = std::vector<local_scalar_t__>(num[(r - 1)], DUMMY_VAR__);
            
            current_statement__ = 88;
            for (int m = 1; m <= num[(r - 1)]; ++m) {
              int i;
              i = std::numeric_limits<int>::min();
              
              current_statement__ = 85;
              i = ii[(((start[(r - 1)] + m) - 1) - 1)];
              current_statement__ = 86;
              assign(log_items, cons_list(index_uni(m), nil_index_list()),
                ((y[(((start[(r - 1)] + m) - 1) - 1)] *
                   stan::math::log(
                     rvalue(pi,
                       cons_list(index_uni(i),
                         cons_list(index_uni(c), nil_index_list())), "pi")))
                  +
                  ((1 - y[(((start[(r - 1)] + m) - 1) - 1)]) *
                    stan::math::log(
                      (1 -
                        rvalue(pi,
                          cons_list(index_uni(i),
                            cons_list(index_uni(c), nil_index_list())), "pi"))))),
                "assigning variable log_items");}
            current_statement__ = 89;
            assign(ps, cons_list(index_uni(c), nil_index_list()),
              (log_Vc[(c - 1)] + sum(log_items)), "assigning variable ps");}
          current_statement__ = 92;
          lp_accum__.add(log_sum_exp(ps));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_test_dina_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> Vc;
      Vc = Eigen::Matrix<double, -1, 1>(C);
      stan::math::fill(Vc, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> Vc_in__;
      Vc_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((C - 1));
      stan::math::fill(Vc_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      Vc_in__ = in__.vector((C - 1));
      current_statement__ = 1;
      assign(Vc, nil_index_list(), stan::math::simplex_constrain(Vc_in__),
        "assigning variable Vc");
      std::vector<double> slip;
      slip = std::vector<double>(I, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 2;
        assign(slip, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable slip");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 2;
        assign(slip, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(slip[(sym1__ - 1)], 0, 1),
          "assigning variable slip");}
      std::vector<double> guess;
      guess = std::vector<double>(I, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 3;
        assign(guess, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable guess");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 3;
        assign(guess, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(guess[(sym1__ - 1)], 0, 1),
          "assigning variable guess");}
      Eigen::Matrix<double, -1, 1> log_Vc;
      log_Vc = Eigen::Matrix<double, -1, 1>(C);
      stan::math::fill(log_Vc, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> pi;
      pi = Eigen::Matrix<double, -1, -1>(I, C);
      stan::math::fill(pi, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        vars__.emplace_back(Vc[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        vars__.emplace_back(slip[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        vars__.emplace_back(guess[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 4;
      assign(log_Vc, nil_index_list(), stan::math::log(Vc),
        "assigning variable log_Vc");
      current_statement__ = 10;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 8;
        for (int c = 1; c <= C; ++c) {
          current_statement__ = 6;
          assign(pi,
            cons_list(index_uni(i),
              cons_list(index_uni(c), nil_index_list())),
            (pow((1 - slip[(i - 1)]),
               rvalue(Xi,
                 cons_list(index_uni(i),
                   cons_list(index_uni(c), nil_index_list())), "Xi")) *
              pow(guess[(i - 1)],
                (1 -
                  rvalue(Xi,
                    cons_list(index_uni(i),
                      cons_list(index_uni(c), nil_index_list())), "Xi")))),
            "assigning variable pi");}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          vars__.emplace_back(log_Vc[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            vars__.emplace_back(
              rvalue(pi,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "pi"));}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> Vc;
      Vc = Eigen::Matrix<double, -1, 1>(C);
      stan::math::fill(Vc, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Vc_flat__;
        current_statement__ = 1;
        assign(Vc_flat__, nil_index_list(), context__.vals_r("Vc"),
          "assigning variable Vc_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          current_statement__ = 1;
          assign(Vc, cons_list(index_uni(sym1__), nil_index_list()),
            Vc_flat__[(pos__ - 1)], "assigning variable Vc");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> Vc_free__;
      Vc_free__ = Eigen::Matrix<double, -1, 1>((C - 1));
      stan::math::fill(Vc_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(Vc_free__, nil_index_list(), stan::math::simplex_free(Vc),
        "assigning variable Vc_free__");
      std::vector<double> slip;
      slip = std::vector<double>(I, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(slip, nil_index_list(), context__.vals_r("slip"),
        "assigning variable slip");
      std::vector<double> slip_free__;
      slip_free__ = std::vector<double>(I, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 2;
        assign(slip_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(slip[(sym1__ - 1)], 0, 1),
          "assigning variable slip_free__");}
      std::vector<double> guess;
      guess = std::vector<double>(I, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(guess, nil_index_list(), context__.vals_r("guess"),
        "assigning variable guess");
      std::vector<double> guess_free__;
      guess_free__ = std::vector<double>(I, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        current_statement__ = 3;
        assign(guess_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(guess[(sym1__ - 1)], 0, 1),
          "assigning variable guess_free__");}
      for (int sym1__ = 1; sym1__ <= (C - 1); ++sym1__) {
        vars__.emplace_back(Vc_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        vars__.emplace_back(slip_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        vars__.emplace_back(guess_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("Vc");
    names__.emplace_back("slip");
    names__.emplace_back("guess");
    names__.emplace_back("log_Vc");
    names__.emplace_back("pi");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(C)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(C)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I),
                                             static_cast<size_t>(C)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "Vc" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "slip" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "guess" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_Vc" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "pi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= (C - 1); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "Vc" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "slip" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "guess" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_Vc" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "pi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"Vc\",\"type\":{\"name\":\"vector\",\"length\":" << C << "},\"block\":\"parameters\"},{\"name\":\"slip\",\"type\":{\"name\":\"array\",\"length\":" << I << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"guess\",\"type\":{\"name\":\"array\",\"length\":" << I << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log_Vc\",\"type\":{\"name\":\"vector\",\"length\":" << C << "},\"block\":\"transformed_parameters\"},{\"name\":\"pi\",\"type\":{\"name\":\"matrix\",\"rows\":" << I << ",\"cols\":" << C << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"Vc\",\"type\":{\"name\":\"vector\",\"length\":" << (C - 1) << "},\"block\":\"parameters\"},{\"name\":\"slip\",\"type\":{\"name\":\"array\",\"length\":" << I << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"guess\",\"type\":{\"name\":\"array\",\"length\":" << I << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log_Vc\",\"type\":{\"name\":\"vector\",\"length\":" << C << "},\"block\":\"transformed_parameters\"},{\"name\":\"pi\",\"type\":{\"name\":\"matrix\",\"rows\":" << I << ",\"cols\":" << C << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_test_dina_namespace::model_test_dina;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_test_dina_namespace::profiles__;
}
#endif
#endif
