% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_unit.R
\encoding{UTF-8}
\name{conv_unit}
\alias{conv_unit}
\title{Convert Units of Measurement}
\usage{
conv_unit(x, from, to)
}
\arguments{
\item{x}{a numeric vector giving the measurement value in its original units.}

\item{from}{the unit in which the measurement was made.}

\item{to}{the unit to which the measurement is to be converted.}
}
\description{
Converts common units of measurement for a variety of dimensions. See \code{\link{conv_unit_options}} for all options.
}
\details{
\describe{
 \item{Acceleration}{mm_per_sec2, cm_per_sec2, m_per_sec2, km_per_sec2, grav, inch_per_sec2, ft_per_sec2, mi_per_sec2, kph_per_sec, mph_per_sec}
 \item{Angle}{degree, radian, grad, arcmin, arcsec, turn}
 \item{Area}{nm2, um2, mm2, cm2, m2, hectare, km2, inch2, ft2, yd2, acre, mi2, naut_mi2}
 \item{Coordinate}{dec_deg, deg_dec_min, deg_min_sec (see note)}
 \item{Count}{nmol, umol, mmol, mol}
 \item{Duration}{nsec, usec, msec, sec, min, hr, day, wk, mon, yr, dec, cen, mil, Ma}
 \item{Energy}{J, kJ, erg, cal, Cal, Wsec, kWh, MWh, BTU}
 \item{Flow}{ml_per_sec, ml_per_min, ml_per_hr, l_per_sec, l_per_min, l_per_hr, m3_per_sec, m3_per_min, m3_per_hr, gal_per_sec, gal_per_min, gal_per_hr, ft3_per_sec, ft3_per_min, ft3_per_hr, Sv}
 \item{Length}{angstrom, nm, um, mm, cm, dm, m, km, inch, ft, yd, fathom, mi, naut_mi, au, light_yr, parsec, point}
 \item{Mass}{ug, mg, g, kg, Pg, carat, metric_ton, oz, lbs, short_ton, long_ton, stone}
 \item{Power}{uW, mW, W, kW, MW, GW, erg_per_sec, cal_per_sec, cal_per_hr, Cal_per_sec, Cal_per_hr, BTU_per_sec, BTU_per_hr, hp}
 \item{Pressure}{uatm, atm, Pa, hPa, kPa, torr, mmHg, inHg, cmH2O, inH2O, mbar, bar, dbar, psi}
 \item{Speed}{mm_per_sec, cm_per_sec, m_per_sec, km_per_sec, inch_per_sec, ft_per_sec, kph, mph, km_per_day, mi_per_day, knot, mach, light}
 \item{Temperature}{C, F, K, R}
 \item{Volume}{ul, ml, dl, l, cm3, dm3, m3, km3, us_tsp, us_tbsp, us_oz, us_cup, us_pint, us_quart, us_gal, inch3, ft3, mi3, imp_tsp, imp_tbsp, imp_oz, imp_cup, imp_pint, imp_quart, imp_gal}
}
The conversion values have been defined based primarily from international weight and measurement authorities (e.g. General Conference on Weights and Measures, International Committee for Weights and Measures, etc.). While much effort was made to make conversions as accurate as possible, you should check the accuracy of conversions to ensure that conversions are precise enough for your applications.
}
\note{
\describe{
 \item{Duration}{Years are defined as 365.25 days and months are defined as 1/12 a year.}
 \item{Coordinate}{Values must be entered as a string with one space between subunits (e.g. 70° 33’ 11” = "70 33 11").}
 \item{Energy}{cal is a thermochemical calorie (4.184 J) and Cal is 1000 cal (kcal or 4184 J).}
 \item{Flow}{All gallon-based units are US gallons.}
 \item{Mass}{All non-metric units are based on the avoirdupois system.}
 \item{Power}{hp is mechanical horsepower, or 745.69 W.}
 \item{Pressure}{cmH2O is defined at 4 °C.}
 \item{Pressure}{inH2O is defined at 60 °F.}
 \item{Speed}{mach is calculated at sea level at 15 °C.}
}
}
\examples{
conv_unit(2.54, "cm", "inch") # Result = 1 inch

conv_unit(seq(1, 10), "kg", "short_ton") # A vector of measurement values can be converted

# Convert 1, 10, and 100 meters to all other length units
sapply(conv_unit_options$length, function(x) conv_unit(c(1, 10, 100), "m", x))

conv_unit("33 1 1", "deg_min_sec", "dec_deg")

conv_unit(c("101 44.32","3 19.453"), "deg_dec_min", "deg_min_sec")

}
\seealso{
\code{\link{conv_unit_options}}, \code{\link{conv_dim}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
