% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_regression.R
\name{KendallTau}
\alias{KendallTau}
\title{Kendall's tau}
\usage{
KendallTau(truth, response)
}
\arguments{
\item{truth}{[numeric] vector of true values}

\item{response}{[numeric] vector of predicted values}
}
\description{
Defined as: Kendall's tau correlation between truth and response. Only looks at the order.
See Rosset et al.: http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.95.1398&rep=rep1&type=pdf.
}
\examples{
n = 20
set.seed(123)
truth = rnorm(n)
response = rnorm(n)
KendallTau(truth, response)
}
