% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_generic.R
\name{extract_generic}
\alias{extract_generic}
\title{Extract Generic Entities From Phrase}
\usage{
extract_generic(phrase, dict)
}
\arguments{
\item{phrase}{Text to search.}

\item{dict}{data.frame, the first column should contain expressions to find.
These can be regular expressions or exact phrases.}
}
\value{
A numeric matrix with position and expression length.
}
\description{
This function searches a phrase for the position and length
of expressions specified in a dictionary. This is called within other main functions of
the package and generally not intended for use on its own.
}
\details{
\code{extract_generic} is used to extract entities that are
identified with an associated dictionary of phrases or regular expressions,
such as dose change, frequency, intake time, route, or duration in
\code{\link{medExtractR}} and \code{\link{medExtractR_tapering}}, as well as
dose schedule, time keyword, transition, and preposition in \code{\link{medExtractR_tapering}}. This function
is called within \code{\link{extract_entities}}.
}
\examples{
data(frequency_vals)
extract_generic("take two every day", dict = frequency_vals)
extract_generic("take two every morning",
                  dict = data.frame(c("morning", "every morning")))
}
