% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.neEffdecomp}
\alias{plot.neEffdecomp}
\alias{plot.neLht}
\title{Confidence interval plots for linear hypotheses in natural effect models}
\usage{
\method{plot}{neEffdecomp}(x, level = 0.95, ci.type = "norm",
  transf = identity, ylabels, yticks.at, ...)

\method{plot}{neLht}(x, level = 0.95, ci.type = "norm", transf = identity,
  ylabels, yticks.at, ...)
}
\arguments{
\item{x}{an object of class \code{neLht}.}

\item{level}{the confidence level required.}

\item{ci.type}{the type of bootstrap intervals required. The default \code{"norm"} returns normal approximation bootstrap confidence intervals. Currently, only \code{"norm"}, \code{"basic"} and \code{"perc"} are supported (see \code{\link[boot]{boot.ci}}).}

\item{transf}{transformation function to be applied internally on the (linear hypothesis) estimates and their confidence intervals (e.g. \code{exp} for logit or Poisson regression). The default is \code{identity} (i.e. no transformation).}

\item{ylabels}{character vector containing the labels for the (linear hypothesis) estimates to be plotted on the y-axis.}

\item{yticks.at}{numeric vector containing the y-coordinates (from 0 to 1) to draw the tick marks for the different estimates and their corresponding confidence intervals.}

\item{...}{additional arguments.}
}
\description{
Confidence interval plots for linear hypotheses in natural effect models.
}
\details{
This function is an adapted version of \code{\link[multcomp]{plot.glht}} from the \pkg{multcomp} package and
yields confidence interval plots for each of the linear hypothesis parameters.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaffect + gender + educ + age,
                    family = binomial, data = UPBdata)
\donttest{neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age,
                 family = binomial, expData = impData)}\dontshow{neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age, family = binomial, expData = impData, nBoot = 2)}

lht <- neLht(neMod, linfct = c("att0 = 0", "att0 + att0:att1 = 0",
                               "att1 = 0", "att1 + att0:att1 = 0",
                               "att0 + att1 + att0:att1 = 0"))

## all pairs return identical output
plot(confint(lht), transf = exp)
plot(lht, transf = exp)

plot(neEffdecomp(neMod), transf = exp)
plot(neMod, transf = exp)

\dontshow{
  plot(neEffdecomp(neMod), level = 0.8, transf = exp, ylabels = c("PDE", "TDE", "PIE", "TIE", "TE"), yticks.at = c(0, 0.1, 0.5, 0.6, 1))
  plot(neMod, level = 0.8, transf = exp, ylabels = c("PDE", "TDE", "PIE", "TIE", "TE"), yticks.at = c(0, 0.1, 0.5, 0.6, 1))

  lht <- neLht(neMod, linfct = c("att0 = 0"))
  summary(lht)
  lht <- neLht(neMod, linfct = c("att0 = 0", "att0 + att0:att1 = 2"))
  summary(lht)
}
}
\seealso{
\code{\link{neModel}}, \code{\link{neEffdecomp}}, \code{\link{plot.neLht}}, \code{\link{plot.neEffdecomp}}
}

