% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pccc_codes.R
\name{get_pccc_codes}
\alias{get_pccc_codes}
\title{Pediatric Complex Chronic Conditions ICD Codes}
\usage{
get_pccc_codes()
}
\value{
a \code{data.frame} with the following columns
\itemize{
\item \code{icdv}: Integer vector indicating if the code is from ICD-9 or ICD-10.
\item \code{dx}: Integer vector.  1 if the code is a diagnostic, (ICD-9-CM,
ICD-10-CM, WHO, CDC Mortality), or 0 if the code is procedural (ICD-9-PCS,
ICD-10-PCS).
\item \code{full_code}: Character vector with the ICD code and any relevant decimal point.
\item \code{code}: Character vector with the compact ICD code omitting any relevant decimal point.
\item \code{condition}: Character vector of the conditions.
\item \code{subcondition}: Character vector of the subconditions.
\item \code{transplant_flag}: Integer vector indicating if the code is associated with a transplant.
\item \code{tech_dep_flag}: Integer vector indicating if the code is associated with technology dependence.
\item \verb{pccc_<variant>}: Integer vector indicating if the code is part of the
v2.0, v2.1, v3.0, or v3.1 variant.
}
}
\description{
Retrieve a copy of internal lookup tables for the ICD codes mapping to the
Pediatric Complex Chronic Conditions (PCCC) conditions and subconditions by
variant.
}
\examples{
head(get_pccc_codes())
str(get_pccc_codes())
}
\seealso{
\itemize{
\item \code{\link[=get_pccc_conditions]{get_pccc_conditions()}} for a reference of the PCCC conditions and
subconditions.
\item \code{\link[=get_icd_codes]{get_icd_codes()}} for the lookup table of all ICD codes.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
