% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.medicalcoder_comorbidities}
\alias{summary.medicalcoder_comorbidities}
\title{Summaries of Comorbidities}
\usage{
\method{summary}{medicalcoder_comorbidities}(object, ...)
}
\arguments{
\item{object}{a \code{medicalcoder_comorbidities} object generated by calling
\code{\link[=comorbidities]{comorbidities()}}}

\item{...}{additional parameters, not currently used}
}
\value{
either a list or a data \code{data.frame}
}
\description{
Build summaries (counts and percentages) for each comorbidity and other
summary statistics by method.
}
\examples{
pccc_v3.1_results <-
  comorbidities(data = mdcr,
                icd.codes = "code",
                id.vars = "patid",
                dx.var = "dx",
                method = "pccc_v3.1",
                flag.method = 'current',
                poa = 1)
summary(pccc_v3.1_results)

charlson_results <-
  comorbidities(data = mdcr,
                icd.codes = "code",
                id.vars = "patid",
                dx.var = "dx",
                method = "charlson_quan2011",
                flag.method = 'current',
                poa = 1)
summary(charlson_results)

elixhauser_results <-
  comorbidities(data = mdcr,
                icd.codes = "code",
                id.vars = "patid",
                dx.var = "dx",
                method = "elixhauser_ahrq2025",
                primarydx = 1,
                flag.method = 'current',
                poa = 1)
summary(elixhauser_results)

}
