% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_export.R
\name{mx_export}
\alias{mx_export}
\title{Export references for preprints returning by a search to a .bib file}
\usage{
mx_export(data, file = "medrxiv_export.bib")
}
\arguments{
\item{data}{Dataframe returned by mx_search() or mx_api_*() functions}

\item{file}{File location to save to. Must have the .bib file extension}
}
\value{
Exports a formatted .BIB file, for import into a reference manager
}
\description{
Export references for preprints returning by a search to a .bib file
}
\examples{
\donttest{
mx_results <- mx_search(mx_snapshot(), query = "brain")
mx_export(mx_results, tempfile(fileext = ".bib"))
}

}
\seealso{
Other helper: 
\code{\link{mx_caps}()},
\code{\link{mx_crosscheck}()},
\code{\link{mx_download}()}
}
\concept{helper}
