% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_sd.R
\name{el_sd}
\alias{el_sd}
\title{Empirical likelihood for the standard deviation}
\usage{
el_sd(x, mean, sd, weights = NULL, control = el_control())
}
\arguments{
\item{x}{A numeric vector, or an object that can be coerced to a numeric
vector.}

\item{mean}{A single numeric for the (known) mean value.}

\item{sd}{A positive single numeric for the parameter value to be tested.}

\item{weights}{An optional numeric vector of weights to be used in the
fitting process. The length of the vector must be the same as the length of
\code{x}. Defaults to \code{NULL}, corresponding to identical weights. If non-\code{NULL},
weighted empirical likelihood is computed.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}
\value{
An object of class \linkS4class{EL}.
}
\description{
Computes empirical likelihood for the standard deviation.
}
\examples{
set.seed(4097)
x <- rnorm(100, mean = -2, sd = 3)
el_sd(x, mean = -2, sd = 3.5)
}
\seealso{
\code{\link[=el_control]{el_control()}}, \code{\link[=el_mean]{el_mean()}}, \code{\link[=elt]{elt()}}
}
