% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pVal-methods.R
\name{pVal}
\alias{pVal}
\alias{pVal,EL-method}
\alias{pVal,ELMT-method}
\alias{pVal,ELT-method}
\title{\eqn{p}-value}
\usage{
\S4method{pVal}{EL}(object, ...)

\S4method{pVal}{ELMT}(object, ...)

\S4method{pVal}{ELT}(object, ...)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL},
\linkS4class{ELT}, or \linkS4class{ELMT}.}

\item{...}{Further arguments passed to methods.}
}
\value{
The form of the value returned by [pVal()] depends on the class of
  its argument.
}
\description{
Extracts \eqn{p}-value from a model.
}
\section{Methods (by class)}{
\itemize{
\item \code{pVal(EL)}: Extracts the \eqn{p}-value.

\item \code{pVal(ELMT)}: Extracts the multiplicity adjusted \eqn{p}-values.

\item \code{pVal(ELT)}: Extracts the \eqn{p}-value.

}}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
pVal(fit)
}
\seealso{
\linkS4class{EL}, \linkS4class{ELT}, \linkS4class{ELMT}, [chisq()]
}
