% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grow_ws}
\alias{grow_ws}
\title{Watts & Strogatz (2002) network growth model}
\usage{
grow_ws(n = 100L, k = 10L, p = 0.2)
}
\arguments{
\item{n}{Integer. Number of nodes in the network.}

\item{k}{Integer. Number of edges added for each incoming node. Can only be
even.}

\item{p}{Numeric. Proability that an edge e_ij is rewired to e_ik with k being
randomly drawn from the set of nodes.}
}
\value{
n x n adjacency matrix.
}
\description{
Grow networks using Watts & Strogatz (1999) growth model, which constructs
in-between regular lattices and random networks by re-wiring edges of a
regular lattice with probability \code{p}.
}
\examples{
# generate small, mildly random graph
grow_ws(n = 6, k = 2, p = .2)

\dontrun{
# generate large, mildly random graph
grow_ws(n = 100, k = 10, p = .1)

# generate large, highly random graph
grow_ws(n = 100, k = 10, p = 10)
}

}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’
networks. Nature, 393(6684), 440-442.
}
