% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MR_test.R
\name{MR_test}
\alias{MR_test}
\title{LM test against a change in persistence}
\usage{
MR_test(x, trend = c("none", "linear"), tau = 0.2,
  statistic = c("standard", "squared"), simu = 0, M = 10000, p = 0,
  twostep = c(FALSE, TRUE))
}
\arguments{
\item{x}{the univariate numeric time series to be investigated.}

\item{trend}{whether the time series exhibits a trend, \code{none} implies no trend and \code{linear} implies a linear trend.}

\item{tau}{the function tests in the interval \code{[T*tau,T*(1-tau)]} for a break in persistence with T being the length of the time series. It must hold that \code{0<tau<0.5}, default is \code{tau=0.2} as commonly used in the literature.}

\item{statistic}{which type of test statistic should be used, \code{standard} for the standard t-test and \code{squared} for the squared test statistic.}

\item{simu}{whether critical values should be simulated or interpolated, \code{simu=1} means simulation, \code{simu=0} means interpolation. See details. Default is \code{simu=0}.}

\item{M}{number of replications in case critical values should be simulated. Default is \code{M=10000}.}

\item{p}{order of the AR-model used to account for serial correlation of the errors. Default is \code{p=0}.}

\item{twostep}{boolean, indicating whether the two step procedure or the one step procedure should be used. Default is \code{twostep=FALSE}.}
}
\value{
Returns a matrix that consists of test statistic and critical values (corresponding to \code{alpha=0.1,0.05,0.01}) for testing against an increase in memory, against a decrease in memory, and against a change in an unknown direction.
}
\description{
This function performs a LM-type test for a change in persistence as suggested by Martins and Rodrigues (2014).
Under the null hypothesis the memory parameter d is constant over the sample. Under the alternative
an increase or a decrease of the memory parameter has occured over time.
}
\details{
The critical values of the tests vary with sample size and memory parameter d. If \code{simu=0}, the critical values provided
are based on linear interpolation of the critical values simulated by Martins and Rodrigues (2014). These are based on \code{tau=0.2}.
If \code{simu=1}, the critical values are simulated based on the given data using M replications. Caution, for large M this might take a while,
small M, however, make the results unreliable.
}
\examples{
library(fracdiff)
library(LongMemoryTS)
series<- c(rnorm(200),cumsum(rnorm(200)))
MR_test(series,trend="none",statistic="standard",twostep=FALSE)
}
\references{
Martins, L.. and Rodrigues, P. (2014): Testing for persistence change in fractionally integrated models: An application to world inflation rates. Computational Statistics and Data Analysis, 76, pp. 502-522.
}
\author{
Janis Becker
}
