% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merData.R
\name{draw}
\alias{draw}
\alias{draw.merMod}
\title{Draw a single observation out of an object matching some criteria}
\usage{
draw(object, type = c("random", "average"), varList = NULL, seed = NULL)

\method{draw}{merMod}(object, type = c("random", "average"), varList = NULL,
  seed = NULL)
}
\arguments{
\item{object}{the object to draw from}

\item{type}{what kind of draw to make. Options include random or average}

\item{varList}{a list specifying filters to subset the data by when making the
draw}

\item{seed}{numeric, optional argument to set seed for simulations, ignored if type="average"}
}
\value{
a data.frame with a single row representing the desired observation
}
\description{
Draw is used to select a single observation out of an R object.
Additional parameters allow the user to control how that observation is
chosen in order to manipulate that observation later. This is a generic
function with methods for a number of objects.
}
\details{
In cases of tie, ".", may be substituted for factors.
}
\examples{
fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
# Random case
draw(fm1, type = "random")
# Average
draw(fm1, type = "average")
# Subset
draw(fm1, type = "average", varList = list("Subject" = "308"))

}

