% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaadd.R
\name{metaadd}
\alias{metaadd}
\title{Add pooled results from external analysis to meta-analysis}
\usage{
metaadd(
  x,
  type,
  TE,
  lower,
  upper,
  statistic = NA,
  pval = NA,
  text,
  data = NULL
)
}
\arguments{
\item{x}{Meta-analysis object.}

\item{type}{A character string or vector indicating whether added
results are from common effect, random effects model or
prediction interval. Either \code{"common"}, \code{"random"} or
\code{"prediction"}, can be abbreviated.}

\item{TE}{Pooled estimate(s).}

\item{lower}{Lower limit(s) of confidence or prediction interval.}

\item{upper}{Upper limit(s) of confidence or prediction interval.}

\item{statistic}{Test statistic(s).}

\item{pval}{P-value(s).}

\item{text}{A character string or vector used in printouts and
forest plot to label the added results.}

\item{data}{An optional data frame containing the new results.}
}
\value{
An object of class \code{"meta"} with corresponding generic
functions (see \code{\link{meta-object}}).
}
\description{
Add pooled results from external analysis to an existing
meta-analysis object. This is useful, for example, to add results
from a Bayesian meta-analysis which is not implemented in R package
\bold{meta}.
}
\details{
In R package \bold{meta}, objects of class \code{"meta"} contain
results of both common effect and random effects
meta-analyses. This function enables the user to add the pooled
results of an additional analysis to an existing meta-analysis
object. This is useful, for example, to add the result of a
Bayesian meta-analysis.

Arguments \code{TE}, \code{lower} and \code{upper} have to be
provided if \code{type = "common"} or \code{type = "random"}. For
\code{type = "prediction"}, only arguments \code{lower} and
\code{upper} have to be provided and other arguments are ignored.

Note, R function \code{\link{metamerge}} can be used to add
meta-analysis results of another meta-analysis object (see
\code{\link{meta-object}}).
}
\examples{
data(Fleiss1993bin)

# Use REML estimator of tau2 (default)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin,
  studlab = paste(study, year), sm = "OR",
  text.random = "Random effects model (REML)", overall.hetstat = FALSE)

# Use DerSimonian-Laird estimator of tau2
m2 <- update(m1, method.tau = "DL")

# Add random effects results of second meta-analysis
m12 <- metaadd(m1, type = "random", data = m2,
  TE = TE.random,
  lower = lower.random, upper = upper.random,
  statistic = statistic.random, pval = pval.random,
  text = "Random effects model (DL)")
m12

forest(m12)

}
\seealso{
\code{\link{metagen}}, \code{\link{metamerge}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
