% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metarate.R
\name{metarate}
\alias{metarate}
\title{Meta-analysis of single incidence rates}
\usage{
metarate(
  event,
  time,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  cluster = NULL,
  rho = 0,
  weights = NULL,
  weights.common = weights,
  weights.random = weights,
  n = NULL,
  method = "Inverse",
  sm = gs("smrate"),
  incr = gs("incr"),
  method.incr = gs("method.incr"),
  method.ci = gs("method.ci.rate"),
  level = gs("level"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  overall = common | random,
  overall.hetstat = if (is.null(gs("overall.hetstat"))) common | random else
    gs("overall.hetstat"),
  prediction = gs("prediction") | !missing(method.predict),
  method.tau,
  method.tau.ci = gs("method.tau.ci"),
  level.hetstat = gs("level.hetstat"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  detail.tau = NULL,
  method.I2 = gs("method.I2"),
  level.ma = gs("level.ma"),
  method.common.ci = gs("method.common.ci"),
  method.random.ci = gs("method.random.ci"),
  adhoc.hakn.ci = gs("adhoc.hakn.ci"),
  level.predict = gs("level.predict"),
  method.predict = gs("method.predict"),
  adhoc.hakn.pi = gs("adhoc.hakn.pi"),
  seed.predict = NULL,
  null.effect = NA,
  method.bias = gs("method.bias"),
  backtransf = gs("backtransf"),
  irscale = 1,
  irunit = "person-years",
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  label.left = gs("label.left"),
  label.right = gs("label.right"),
  col.label.left = gs("col.label.left"),
  col.label.right = gs("col.label.right"),
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  seed.predict.subgroup = NULL,
  byvar,
  hakn,
  adhoc.hakn,
  keepdata = gs("keepdata"),
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{event}{Number of events.}

\item{time}{Person time at risk.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information, i.e., event and time.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{rho}{Assumed correlation of estimates within a cluster.}

\item{weights}{A single numeric or vector with user-specified weights.}

\item{weights.common}{User-specified weights (common effect model).}

\item{weights.random}{User-specified weights (random effects model).}

\item{n}{Number of observations.}

\item{method}{A character string indicating which method is to be
used for pooling of studies. One of \code{"Inverse"} and
\code{"GLMM"}, can be abbreviated.}

\item{sm}{A character string indicating which summary measure
(\code{"IR"}, \code{"IRLN"}, \code{"IRS"}, or \code{"IRFT"}) is
to be used for pooling of studies, see Details.}

\item{incr}{A numeric which is added to the event number of studies
with zero events, i.e., studies with an incidence rate of 0. Or a
numeric vector with the continuity correction for each study.}

\item{method.incr}{A character string indicating which continuity
correction method should be used (\code{"only0"},
\code{"if0all"}, or \code{"all"}), see Details.}

\item{method.ci}{A character string indicating whether to use
approximate normal ("NAsm") or exact Poisson ("Poisson")
confidence limits.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{level.hetstat}{The level used to calculate confidence intervals
for heterogeneity statistics.}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{detail.tau}{Detail on between-study variance estimate.}

\item{method.I2}{A character string indicating which method is
used to estimate the heterogeneity statistic I\eqn{^2}. Either
\code{"Q"} or \code{"tau2"}, can be abbreviated
(see \code{\link{meta-package}}).}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{method.common.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
common effect estimate (see \code{\link{meta-package}}).}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for
prediction interval (see \code{\link{meta-package}}).}

\item{seed.predict}{A numeric value used as seed to calculate
bootstrap prediction interval (see \code{\link{meta-package}}).}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, or
\code{"Thompson"}, can be abbreviated. See function
\code{\link{metabias}}.}

\item{backtransf}{A logical indicating whether results for
transformed rates (argument \code{sm != "IR"}) should be back
transformed in printouts and plots. If TRUE (default), results
will be presented as incidence rates; otherwise transformed rates
will be shown.}

\item{irscale}{A numeric defining a scaling factor for printing of
rates.}

\item{irunit}{A character string specifying the time unit used to
calculate rates, e.g. person-years.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.left}{Graph label on left side of null effect in forest plot.}

\item{label.right}{Graph label on right side of null effect in forest plot.}

\item{col.label.left}{The colour of the graph label on the left side of
the null effect.}

\item{col.label.right}{The colour of the graph label on the right side of
the null effect.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{seed.predict.subgroup}{A numeric vector providing seeds to
calculate bootstrap prediction intervals within subgroups. Must
be of same length as the number of subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{hakn}{Deprecated argument (replaced by 'method.random.ci').}

\item{adhoc.hakn}{Deprecated argument (replaced by 'adhoc.hakn.ci').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if \code{incr} is added to studies with zero cell
frequencies or if estimation problems exist in fitting a GLMM).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}} or
\code{\link[metafor]{rma.glmm}}, respectively.}

\item{\dots}{Additional arguments passed on to
\code{\link[metafor]{rma.glmm}} function and to catch deprecated
arguments.}
}
\value{
An object of class \code{c("metarate", "meta")} with corresponding
generic functions (see \code{\link{meta-object}}).
}
\description{
Calculation of an overall incidence rate from studies reporting a
single incidence rate. Inverse variance method and generalised
linear mixed model (GLMM) are available for pooling. For GLMMs, the
\code{\link[metafor]{rma.glmm}} function from R package
\bold{metafor} (Viechtbauer 2010) is called internally.
}
\details{
This function provides methods for common effect and random effects
meta-analysis of single incidence rates to calculate an overall
rate. Note, you should use R function \code{\link{metainc}} to
compare incidence rates of pairwise comparisons instead of using
\code{metarate} for each treatment arm separately which will break
randomisation in randomised controlled trials.

The following transformations of incidence rates are implemented to
calculate an overall rate:

\itemize{
\item Log transformation (\code{sm = "IRLN"}, default)
\item Square root transformation (\code{sm = "IRS"})
\item Freeman-Tukey Double arcsine transformation (\code{sm =
  "IRFT"})
\item No transformation (\code{sm = "IR"})
}

List elements \code{TE}, \code{TE.common}, \code{TE.random}, etc.,
contain the transformed incidence rates. In printouts and plots
these values are back transformed if argument \code{backtransf =
TRUE} (default).

By default (argument \code{method = "Inverse"}), the inverse
variance method (Borenstein et al., 2010) is used for pooling by
calling \code{\link{metagen}} internally. A random intercept
Poisson regression model (Stijnen et al., 2010) can be utilised
instead with argument \code{method = "GLMM"} which calls the
\code{\link[metafor]{rma.glmm}} function from R package
\bold{metafor}.

A three-level random effects meta-analysis model (Van den Noortgate
et al., 2013) is utilised if argument \code{cluster} is used and at
least one cluster provides more than one estimate. Internally,
\code{\link[metafor]{rma.mv}} is called to conduct the analysis and
\code{\link[metafor]{weights.rma.mv}} with argument \code{type =
"rowsum"} is used to calculate random effects weights.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Continuity correction}{

Three approaches are available to apply a continuity correction:
\itemize{
\item Only studies with a zero cell count (\code{method.incr =
  "only0"})
\item All studies if at least one study has a zero cell count
  (\code{method.incr = "if0all"})
\item All studies irrespective of zero cell counts
  (\code{method.incr = "all"})
}

If the summary measure (argument \code{sm}) is equal to "IR" or
"IRLN", the continuity correction is applied if a study has zero
events, i.e., an incidence rate of 0.

By default, 0.5 is used as continuity correction (argument
\code{incr}). This continuity correction is used both to calculate
individual study results with confidence limits and to conduct
meta-analysis based on the inverse variance method.

For the Freeman-Tukey (Freeman & Tukey, 1950) and square root
transformation as well as GLMMs no continuity correction is used.
Furthermore, the value of \code{incr} is not considered for Poisson
confidence intervals for individual studies (\code{method.ci = "Poisson"}).
}

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Specify the null hypothesis of test for an overall effect}{

Argument \code{null.effect} can be used to specify the rate used
under the null hypothesis in a test for an overall effect.

By default (\code{null.effect = NA}), no hypothesis test is
conducted as it is unclear which value is a sensible choice for the
data at hand.  An overall rate of 2, for example, could be tested
by setting argument \code{null.effect = 2}.

Note, all tests for an overall effect are two-sided with the
alternative hypothesis that the effect is unequal to
\code{null.effect}.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both common effect and random effects models are
calculated regardless of values choosen for arguments
\code{common} and \code{random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{common} and \code{random}. E.g. function
\code{\link{print.meta}} will not print results for the random
effects model if \code{random = FALSE}.

Argument \code{irscale} can be used to rescale rates, e.g.
\code{irscale = 1000} means that rates are expressed as events per
1000 time units, e.g. person-years. This is useful in situations
with (very) low rates. Argument \code{irunit} can be used to
specify the time unit used in individual studies (default:
"person-years"). This information is printed in summaries and
forest plots if argument \code{irscale} is not equal to 1.

A prediction interval will only be shown if \code{prediction =
TRUE}.
}
}
\examples{
# Apply various meta-analysis methods to estimate incidence rates
#
m1 <- metarate(4:1, c(10, 20, 30, 40))
m2 <- update(m1, sm = "IR")
m3 <- update(m1, sm = "IRS")
m4 <- update(m1, sm = "IRFT")
#
m1
m2
m3
m4
#
forest(m1)
forest(m1, irscale = 100)
forest(m1, irscale = 100, irunit = "person-days")
forest(m1, backtransf = FALSE)
\dontrun{
forest(m2)
forest(m3)
forest(m4)
}

m5 <- metarate(40:37, c(100, 200, 300, 400), sm = "IRFT")
m5

}
\references{
Borenstein M, Hedges LV, Higgins JP, Rothstein HR (2010):
A basic introduction to fixed-effect and random-effects models for
meta-analysis.
\emph{Research Synthesis Methods},
\bold{1}, 97--111

Freeman MF & Tukey JW (1950):
Transformations related to the angular and the square root.
\emph{Annals of Mathematical Statistics},
\bold{21}, 607--11

Stijnen T, Hamza TH, Ozdemir P (2010):
Random effects meta-analysis of event outcome in the framework of
the generalized linear mixed model with applications in sparse
data.
\emph{Statistics in Medicine},
\bold{29}, 3046--67

Van den Noortgate W, López-López JA, Marín-Martínez F, Sánchez-Meca J (2013):
Three-level meta-analysis of dependent effect sizes.
\emph{Behavior Research Methods},
\bold{45}, 576--94

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the Metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48
}
\seealso{
\code{\link{meta-package}}, \code{\link{update.meta}},
  \code{\link{metacont}}, \code{\link{metagen}},
  \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
