% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PAIRED_STATISTICS.R
\name{es_from_paired_t}
\alias{es_from_paired_t}
\title{Convert two paired t-test value of two independent groups into several effect size measures}
\usage{
es_from_paired_t(
  paired_t_exp,
  paired_t_nexp,
  n_exp,
  n_nexp,
  r_pre_post_exp,
  r_pre_post_nexp,
  smd_to_cor = "viechtbauer",
  reverse_paired_t
)
}
\arguments{
\item{paired_t_exp}{Paired t-test value of the experimental/exposed group.}

\item{paired_t_nexp}{Paired t-test value of the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{r_pre_post_exp}{pre-post correlation in the experimental/exposed group}

\item{r_pre_post_nexp}{pre-post correlation in the non-experimental/non-exposed group}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_paired_t}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 16. Paired: Paired F- or t-test'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert two paired t-test value of two independent groups into several effect size measures
}
\details{
This function converts paired t-tests of two independent groups value into a Cohen's d (D) and Hedges' g (G) (table 12.2 in Cooper).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate the Cohen's d,} the following formulas are used (Cooper et al., 2019):
\deqn{cohen\_d\_exp = paired\_t\_exp * \sqrt{\frac{2 * (1 - r\_pre\_post\_exp)}{n\_exp}}}
\deqn{cohen\_d\_nexp = paired\_t\_nexp * \sqrt{\frac{2 * (1 - r\_pre\_post\_nexp)}{n\_nexp}}}
\deqn{cohen\_d\_se\_exp = \sqrt{\frac{2 * (1 - r\_pre\_post\_exp)}{n\_exp} + \frac{d\_exp^2}{2 * n\_exp}}}
\deqn{cohen\_d\_se\_nexp = \sqrt{\frac{2 * (1 - r\_pre\_post\_nexp)}{n\_nexp} + \frac{d\_nexp^2}{2 * n\_nexp}}}
\deqn{cohen\_d = d\_exp - d\_nexp}
\deqn{d\_se = \sqrt{cohen\_d\_se\_exp^2 + cohen\_d\_se\_nexp^2}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_paired_t(paired_t_exp = 2.1, paired_t_nexp = 4.2, n_exp = 20, n_nexp = 22)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
