% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_PriorityQueue.r
\name{metaRangePriorityQueue}
\alias{metaRangePriorityQueue}
\title{Process priority queue}
\value{
\verb{<metaRangePriorityQueue>} A \link{metaRangePriorityQueue} object.
}
\description{
Creates a priority queue in form of an \link[R6:R6Class]{R6} class,
that manages the correct process execution order.
}
\examples{

## ------------------------------------------------
## Method `metaRangePriorityQueue$new`
## ------------------------------------------------

# Only for illustration purposes.
pr_queue <- metaRangePriorityQueue$new()
pr_queue

## ------------------------------------------------
## Method `metaRangePriorityQueue$execute_next_process`
## ------------------------------------------------

# Only for illustration purposes.
pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$execute_next_process(verbose = TRUE)

## ------------------------------------------------
## Method `metaRangePriorityQueue$enqueue`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$get_future_queue()

## ------------------------------------------------
## Method `metaRangePriorityQueue$dequeue`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$dequeue(pr$get_PID())
pr_queue$get_future_queue()

## ------------------------------------------------
## Method `metaRangePriorityQueue$sort_future_queue`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$sort_future_queue()
# at least no error

## ------------------------------------------------
## Method `metaRangePriorityQueue$update`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$get_queue()

## ------------------------------------------------
## Method `metaRangePriorityQueue$is_empty`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
stopifnot(pr_queue$is_empty())

## ------------------------------------------------
## Method `metaRangePriorityQueue$get_queue`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$get_queue()

## ------------------------------------------------
## Method `metaRangePriorityQueue$get_future_queue`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$get_future_queue()

## ------------------------------------------------
## Method `metaRangePriorityQueue$get_current_index`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$get_current_index()

## ------------------------------------------------
## Method `metaRangePriorityQueue$print`
## ------------------------------------------------

pr_queue <- metaRangePriorityQueue$new()
pr_queue$print()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-metaRangePriorityQueue-new}{\code{metaRangePriorityQueue$new()}}
\item \href{#method-metaRangePriorityQueue-execute_next_process}{\code{metaRangePriorityQueue$execute_next_process()}}
\item \href{#method-metaRangePriorityQueue-enqueue}{\code{metaRangePriorityQueue$enqueue()}}
\item \href{#method-metaRangePriorityQueue-dequeue}{\code{metaRangePriorityQueue$dequeue()}}
\item \href{#method-metaRangePriorityQueue-sort_future_queue}{\code{metaRangePriorityQueue$sort_future_queue()}}
\item \href{#method-metaRangePriorityQueue-update}{\code{metaRangePriorityQueue$update()}}
\item \href{#method-metaRangePriorityQueue-is_empty}{\code{metaRangePriorityQueue$is_empty()}}
\item \href{#method-metaRangePriorityQueue-get_queue}{\code{metaRangePriorityQueue$get_queue()}}
\item \href{#method-metaRangePriorityQueue-get_future_queue}{\code{metaRangePriorityQueue$get_future_queue()}}
\item \href{#method-metaRangePriorityQueue-get_current_index}{\code{metaRangePriorityQueue$get_current_index()}}
\item \href{#method-metaRangePriorityQueue-print}{\code{metaRangePriorityQueue$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-new"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \link{metaRangePriorityQueue} object.
Note: No reason to call this as user.
The priority queue is created automatically when a simulation is created.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<metaRangePriorityQueue>} A \link{metaRangePriorityQueue} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Only for illustration purposes.
pr_queue <- metaRangePriorityQueue$new()
pr_queue
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-execute_next_process"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-execute_next_process}{}}}
\subsection{Method \code{execute_next_process()}}{
Executes the next process in the queue.
No reason to call this as user. The next process is executed automatically.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$execute_next_process(verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{\verb{<logical>} Print timing and information or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<logical>} \code{TRUE} if the next process has been executed,
\code{FALSE} if not and the queue is empty.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Only for illustration purposes.
pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$execute_next_process(verbose = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-enqueue"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-enqueue}{}}}
\subsection{Method \code{enqueue()}}{
Add a process to the (future) queue.
Users should only use this method if they added a process to the simulation
via the add_process method of the simulation object with the argument
\code{queue = FALSE}. Otherwise the process is added to the queue automatically.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$enqueue(process)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{process}}{\verb{<metaRangeProcess>} A \link{metaRangeProcess} that should be added
to the queue.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<boolean>} \code{TRUE} on success \code{FALSE} on failure.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$get_future_queue()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-dequeue"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-dequeue}{}}}
\subsection{Method \code{dequeue()}}{
Remove a process from the (future) queue.
Useful to remove a process from the queue if it is no longer needed.
E.g. if a species went extinct.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$dequeue(PID = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{PID}}{\verb{<string>} the ID of the process, that should be dequeued.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<boolean>} \code{TRUE} on success \code{FALSE} on failure.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$dequeue(pr$get_PID())
pr_queue$get_future_queue()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-sort_future_queue"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-sort_future_queue}{}}}
\subsection{Method \code{sort_future_queue()}}{
Sort the (future) queue based on the execution priority.
This method is called automatically when a process is added to the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$sort_future_queue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$sort_future_queue()
# at least no error
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-update"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-update}{}}}
\subsection{Method \code{update()}}{
Update and reset the queue.
This method is called automatically at the end of each time step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$update()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$get_queue()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Check if the queue is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<boolean>} \code{TRUE} if queue is empty \code{FALSE} otherwise.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
stopifnot(pr_queue$is_empty())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-get_queue"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-get_queue}{}}}
\subsection{Method \code{get_queue()}}{
Get the current queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$get_queue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<named int vector>} The current queue.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$get_queue()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-get_future_queue"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-get_future_queue}{}}}
\subsection{Method \code{get_future_queue()}}{
Get the future queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$get_future_queue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<named int vector>} The future queue.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$get_future_queue()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-get_current_index"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-get_current_index}{}}}
\subsection{Method \code{get_current_index()}}{
Get the number / index of the next to be executed process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$get_current_index()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<integer>} The index.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr <- metaRangeProcess$new("A", "1", \() {message("test")}, 1, new.env())
pr_queue$enqueue(pr)
pr_queue$update()
pr_queue$get_current_index()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangePriorityQueue-print"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangePriorityQueue-print}{}}}
\subsection{Method \code{print()}}{
Prints information about the queue to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangePriorityQueue$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr_queue <- metaRangePriorityQueue$new()
pr_queue$print()
}
\if{html}{\out{</div>}}

}

}
}
