% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaSDTreg.r
\name{metaSDTreg}
\alias{metaSDTreg}
\title{Meta-SDT regression}
\usage{
metaSDTreg(
  formula,
  data,
  subset,
  na.action = na.fail,
  control = metaSDTcontrol()
)
}
\arguments{
\item{formula}{Formula specifying the regression model. Presently, the left-hand side should be the ordinal variable A, while the right-hand side must contain the signal variable from the metaSDTdata object. Note that the variable 'signal' has a special interpretation in the model, see 'Details' below.}

\item{data}{Data frame to fit the model on. Should be declared as metaSDTdata using the \code{\link{metaSDTdata}} function.}

\item{subset}{Optional argument specifying a subset of the data to be used. A logical statement, which is evaluated in 'data'. Only rows with TRUE are used in the analysis.}

\item{na.action}{Method for handling missing values, see na.action. Default is na.fail which stops the function with an error in the presence of missing values among variables entering 'formula'.}

\item{control}{Optimisation control, see \code{\link{metaSDTcontrol}}.}
}
\value{
An object of class 'metaSDTreg'. This is a list object containing,
\itemize{
 \item logLik: The log likelihood after optimisation.
 \item coefficients: Estimated coefficients.
 \item vcov: Variance-covariance matrix of the maxLik object.
 \item call: The call issued to metaSDTreg.
 \item na.act: The NA action.
}
}
\description{
Fit the meta SDT regression model.
}
\details{
The input data frame should be of class 'metaSDTdata' as constructed by the function \code{\link{metaSDTdata}}. This will contain a variable, 'signal' which presently must be included on the right-hand side of the formula. The left hand side must be the ordinal variable 'A' also contained in the metaSDTdata object.
The 'signal' variable has a special interpretation as its coefficients are the signal sensitivities (type 1 d-prime and the two response specific type 2 sensitivities meta-d-prime). Presently all other variables, as determined by \code{all.vars(update(formula, . ~ . - signal ))}, enter proportionally in the model, i.e. they share cofficients across response scale levels. See Kristensen & al. (2020) for details.
This can be written formally as follows (in the notation of Kristensen & al. (2020)): 
    \deqn{    V_{\mathcal{N}} = V_{\mathcal{S}} = V ,  }
and \eqn{ \beta_{\mathcal{N}} }, \eqn{ \beta_{\mathcal{S}} } and \eqn{ \beta } agree on all but the first entrance which is the signal sensitivities \eqn{ d_{mathcal{N}} }, \eqn{ d_{mathcal{S}} } and \eqn{ d }, respectively.
Note that 'formula' specifies the mean of the latent variables and not the threshold model. Accordingly, attemps to remove the intercept in 'formula' will be ignored with a warning.
The function fails when the left-hand side of 'formula' is not the ordinal variable 'A' and when 'data' is not a 'metaSDTdata' object. Future versions may be less defensive and simply issue a warning in these cases.
Note that constrained optimisation is used to maximise the likelihood under ordinality of the thresholds. The variance-covariance matrix is not adjusted following the constrained estimation, cf. documentation of \code{\link[maxLik]{maxLik}}.
When interpreting results from \code{summary.metaSDTreg()} care should be taken regarding the z-testor and associated p-value for threshold parameters, as the distribution of the statistic depends on the null hypothesis which will only be reasonable under special circumstances as in other types of ordinal models.
}
\examples{
## Declare simulated data as metaSDTdata
metadata <- metaSDTdata(simMetaData, type1='resp', type2='conf', signal='S')

## Fit function to data of first 20 replications per subject
fit_sub <- metaSDTreg(A ~ signal,
                      data=metadata,
                      subset = m <= 20)
summary(fit_sub)

\donttest{
## Fit model to estimate thresholds and sensitivities
fit <- metaSDTreg(A ~ signal,
            data=metadata)

## True values are
## c(tau.n.2=-0.5, tau.n.1=-0.2, theta=0,
##   tau.s.1=0.8, tau.s.2=1, d.n=0.5, d=1, d.s=0.75)
coef(fit)
}


}
\references{
Kristensen, S. B., Sandberg, K., & Bibby, B. M. (2020). Regression
methods for metacognitive sensitivity. Journal of Mathematical
Psychology, 94. <doi:10.1016/j.jmp.2019.102297>.
}
