% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_tree.R
\name{heat_tree}
\alias{heat_tree}
\alias{heat_tree.default}
\alias{heat_tree.taxmap}
\title{Plot a taxonomic tree}
\usage{
heat_tree(...)

\method{heat_tree}{taxmap}(.input, ...)

\method{heat_tree}{default}(taxon_id, supertaxon_id, node_label = NA,
  edge_label = NA, tree_label = NA, node_size = 1,
  edge_size = node_size, node_label_size = node_size,
  edge_label_size = edge_size, tree_label_size = as.numeric(NA),
  node_color = "#999999", edge_color = node_color, tree_color = NA,
  node_label_color = "#000000", edge_label_color = "#000000",
  tree_label_color = "#000000", node_size_trans = "area",
  edge_size_trans = node_size_trans,
  node_label_size_trans = node_size_trans,
  edge_label_size_trans = edge_size_trans, tree_label_size_trans = "area",
  node_color_trans = "area", edge_color_trans = node_color_trans,
  tree_color_trans = "area", node_label_color_trans = "area",
  edge_label_color_trans = "area", tree_label_color_trans = "area",
  node_size_range = c(NA, NA), edge_size_range = c(NA, NA),
  node_label_size_range = c(NA, NA), edge_label_size_range = c(NA, NA),
  tree_label_size_range = c(NA, NA),
  node_color_range = quantative_palette(),
  edge_color_range = node_color_range,
  tree_color_range = quantative_palette(),
  node_label_color_range = quantative_palette(),
  edge_label_color_range = quantative_palette(),
  tree_label_color_range = quantative_palette(),
  node_size_interval = range(node_size, na.rm = TRUE, finite = TRUE),
  node_color_interval = NULL, edge_size_interval = range(edge_size, na.rm =
  TRUE, finite = TRUE), edge_color_interval = NULL, node_label_max = 40,
  edge_label_max = 40, tree_label_max = 40, overlap_avoidance = 1,
  margin_size = c(0, 0), layout = "reingold-tilford",
  initial_layout = "fruchterman-reingold", make_legend = TRUE,
  title = NULL, title_size = 0.08, node_color_axis_label = NULL,
  node_size_axis_label = NULL, edge_color_axis_label = NULL,
  edge_size_axis_label = NULL, background_color = "#FFFFFF00",
  output_file = NULL, ...)
}
\arguments{
\item{...}{(other named arguments)
Passed to the \code{\link{igraph}} layout function used.}

\item{.input}{An object of type \code{\link{taxmap}}}

\item{taxon_id}{The unique ids of taxa.}

\item{supertaxon_id}{The unique id of supertaxon \code{taxon_id} is a part of.}

\item{node_label}{See details on labels.
Default: no labels.}

\item{edge_label}{See details on labels.
Default: no labels.}

\item{tree_label}{See details on labels.
The label to display above each graph.
The value of the root of each graph will be used.
Default: None.}

\item{node_size}{See details on size.
Default: constant size.}

\item{edge_size}{See details on size.
Default: relative to node size.}

\item{node_label_size}{See details on size.
Default: relative to veterx size.}

\item{edge_label_size}{See details on size.
Default: relative to edge size.}

\item{tree_label_size}{See details on size.
Default: relative to graph size.}

\item{node_color}{See details on colors.
Default: grey.}

\item{edge_color}{See details on colors.
Default: same as node color.}

\item{tree_color}{See details on colors.
The value of the root of each graph will be used.
Overwrites the node and edge color if specified.
Default: Not used.}

\item{node_label_color}{See details on colors.
Default: black.}

\item{edge_label_color}{See details on colors.
Default: black.}

\item{tree_label_color}{See details on colors.
Default: black.}

\item{node_size_trans}{See details on transformations.
Default: \code{"area"}.}

\item{edge_size_trans}{See details on transformations. 
Default: same as \code{node_size_trans}.}

\item{node_label_size_trans}{See details on transformations. 
Default: same as \code{node_size_trans}.}

\item{edge_label_size_trans}{See details on transformations. 
Default: same as \code{edge_size_trans}.}

\item{tree_label_size_trans}{See details on transformations.
Default: \code{"area"}.}

\item{node_color_trans}{See details on transformations. 
Default: \code{"area"}.}

\item{edge_color_trans}{See details on transformations.
Default: same as node color transformation.}

\item{tree_color_trans}{See details on transformations.
Default: \code{"area"}.}

\item{node_label_color_trans}{See details on transformations.
Default: \code{"area"}.}

\item{edge_label_color_trans}{See details on transformations.
Default: \code{"area"}.}

\item{tree_label_color_trans}{See details on transformations. 
Default: \code{"area"}.}

\item{node_size_range}{See details on ranges.
Defualt: Optimize to balance overlaps and range size.}

\item{edge_size_range}{See details on ranges.
Default: relative to node size range.}

\item{node_label_size_range}{See details on ranges.
Default: relative to node size.}

\item{edge_label_size_range}{See details on ranges.
Default: relative to edge size.}

\item{tree_label_size_range}{See details on ranges.
Default: relative to tree size.}

\item{node_color_range}{See details on ranges.
Default: Color-blind friendly palette.}

\item{edge_color_range}{See details on ranges.
Default: same as node color.}

\item{tree_color_range}{See details on ranges.
Default: Color-blind friendly palette.}

\item{node_label_color_range}{See details on ranges.
Default: Color-blind friendly palette.}

\item{edge_label_color_range}{See details on ranges.
Default: Color-blind friendly palette.}

\item{tree_label_color_range}{See details on ranges.
Default: Color-blind friendly palette.}

\item{node_size_interval}{See details on intervals.
Default: The range of values in \code{node_size}.}

\item{node_color_interval}{See details on intervals.
Default: The range of values in \code{node_color}.}

\item{edge_size_interval}{See details on intervals.
Default: The range of values in \code{edge_size}.}

\item{edge_color_interval}{See details on intervals.
Default: The range of values in \code{edge_color}.}

\item{node_label_max}{The maximum number of node labels.
Default: 20.}

\item{edge_label_max}{The maximum number of edge labels.
Default: 20.}

\item{tree_label_max}{The maximum number of tree labels.
Default: 20.}

\item{overlap_avoidance}{(\code{numeric})
The relative importance of avoiding overlaps vs maximizing size range.
Higher numbers will cause node size optimazation to avoid overlaps more.
Default: \code{1}.}

\item{margin_size}{(\code{numeric} of length 2)
The horizontal and vertical margins.
Default: \code{0, 0}.}

\item{layout}{The layout algorithm used to position nodes.
See details on layouts.
Default: \code{"reingold-tilford"}.}

\item{initial_layout}{he layout algorithm used to set the initial position
of nodes, passed as input to the \code{layout} algorithm.
See details on layouts.
Default: Not used.}

\item{make_legend}{if TRUE...}

\item{title}{Name to print above the graph.}

\item{title_size}{The size of the title realtive to the rest of the graph.}

\item{node_color_axis_label}{The label on the scale axis corresponding to \code{node_color}.
Default: The expression given to \code{node_color}.}

\item{node_size_axis_label}{The label on the scale axis corresponding to \code{node_size}.
Default: The expression given to \code{node_size}.}

\item{edge_color_axis_label}{The label on the scale axis corresponding to \code{edge_color}.
Default: The expression given to \code{edge_color}.}

\item{edge_size_axis_label}{The label on the scale axis corresponding to \code{edge_size}.
Default: The expression given to \code{edge_size}.}

\item{background_color}{The background color of the plot.
Default: Transparent}

\item{output_file}{The path to a file to save the plot in using \code{\link[ggplot2]{ggsave}}. 
The type of the file will be determined by the extension given.
Default: Do not save plot.}
}
\description{
Plots the distribution of values associated with a taxonomic classification.
Taxonomic classifications can have multiple roots, resulting in multiple trees on the same plot.
Sizes and colors of nodes, edges, labels, and individual trees can be displayed relative to
numbers (e.g. taxon statistics, such as abundance).
The displayed range of colors and sizes can be explicitly defined or automatically genereated.
Various transforamtions can be applied to numbers sizes/colors are mapped to.
Several types of tree layout algorithms from \code{\link{igraph}} can be used.
}
\section{size}{



The size of nodes, edges, labels, and trees can be mapped to arbitrary numbers.
This is useful for displaying statistics for taxa, such as abundance.
Only the relative size of numbers is used, not the values themeselves.
They can be transformed to make the mapping non-linear using the transformation options.
The range of actual sizes displayed on the graph can be set using the range options.

Accepts a \code{numeric} vector, the same length \code{taxon_id} or a
factor of its length.
}

\section{colors}{


The colors of nodes, edges, labels, and trees can be mapped to arbitrary numbers.
This is useful for highlighting groups of taxa.
Only the relative size of numbers is used, not the values themeselves.
They can be transformed to make the mapping non-linear using the transformation options.
The range of actual colors displayed on the graph can be set using the range options.

Accepts a vector, the same length \code{taxon_id} or a factor of its length.
If a numeric vector is given, it is mapped to a color scale.
Hex values or color names can be used (e.g. \code{#000000} or \code{"black"}).
}

\section{labels}{


The labels of nodes, edges, and trees can be added.
Node labels are centered over their node.
Edge labels are displayed over edges, in the same orientation.
Tree labels are displayed over their tree.

Accepts a vector, the same length \code{taxon_id} or a factor of its length.
}

\section{transformations}{


Before any numbers specified are mapped to color/size, they can be transformed to make
the mapping non-linear. 
Any of the transformations listed below can be used by specifying their name.
A customized function can also be supplied to do the transformation.

\describe{
  \item{"linear"}{Proprotional to radius/diameter of node}
  \item{"area"}{circular area; better perceptual accuracy than \code{"linear"}}
  \item{"log10"}{Log base 10 of radius}
  \item{"log2"}{Log base 2 of radius}
  \item{"ln"}{Log base e of radius}
  \item{"log10 area"}{Log base 10 of circular area}
  \item{"log2 area"}{Log base 2 of circular area}
  \item{"ln area"}{Log base e of circular area}
}
}

\section{ranges}{


The displayed range of colors and sizes can be explicitly defined or automatically genereated.
Size ranges are specified by supplying a \code{numeric} vector with two values: the minimum and maximum.
The units used should be between 0 and 1, representing the proportion of a dimension of the graph.
Since the dimensions of the graph are determined by layout, and not always square, the value
that \code{1} corresponds to is the square root of the graph area (i.e. the side of a square with 
the same area as the plotted space).
Color ranges can be any number of color values as either HEX codes (e.g. \code{#000000}) or
color names (e.g. \code{"black"}).
}

\section{layout}{


Layouts determine the position of nodes on the graph.
The are implemented using the \code{\link{igraph}} package.
Any additional arguments passed to \code{heat_tree} are passed to the  \code{\link{igraph}}
function used.
The following \code{character} values are understood:

\describe{
  \item{"automatic"}{Use \code{\link[igraph]{nicely}}. Let \code{\link{igraph}} choose the layout.}
  \item{"reingold-tilford"}{Use \code{\link[igraph]{as_tree}}. A circular tree-like layout.}
  \item{"davidson-harel"}{Use \code{\link[igraph]{with_dh}}. A type of simulated annealing.}
  \item{"gem"}{Use \code{\link[igraph]{with_gem}}. A force-directed layout.}
  \item{"graphopt"}{Use \code{\link[igraph]{with_graphopt}}. A force-directed layout.}
  \item{"mds"}{Use \code{\link[igraph]{with_mds}}. Multidimensional scaling.}
  \item{"fruchterman-reingold"}{Use \code{\link[igraph]{with_fr}}. A force-directed layout.}
  \item{"kamada-kawai"}{Use \code{\link[igraph]{with_kk}}. A layout based on a phyisical model of springs.}
  \item{"large-graph"}{Use \code{\link[igraph]{with_lgl}}. Meant for larger graphs.}
  \item{"drl"}{Use \code{\link[igraph]{with_drl}}. A force-directed layout.}
}
}

\section{intervals}{


This is the minimum and maximum of values displayed on the legend scales.
Intervals are specified by supplying a \code{numeric} vector with two values: the minimum and maximum.
These are defined in the same units as element size/color.
By default, the minimum and maximum equals the range of the values used to infer size/color.
Setting a custom interval is useful for making size/color in multiple graphs correspond to the same statistics,
or setting logical bounderies (such as \code{c(0,1)} for proportions.
Note that this is different from the "range" options, which determine the range of graphed sizes/colors.
}
\examples{
heat_tree(contaminants,
          node_size = n_obs,
          node_color = n_obs,
          node_label = name,
          tree_label = name,
          layout = "fruchterman-reingold")

}
\keyword{internal}

