% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--select.R
\name{select_taxa}
\alias{select_taxa}
\title{Subset columns in a \code{\link{taxmap}} object}
\usage{
select_taxa(.data, ...)
}
\arguments{
\item{.data}{\code{\link{taxmap}}}

\item{...}{One or more column names to return in the new object. This can be one of three things:
\describe{ \item{\code{expression with unquoted column name}}{The name of a column in
\code{taxon_data} typed as if it was a varaible on its own.} \item{\code{numeric}}{Indexes of
columns in \code{taxon_data}} } To match column names with a character vector, use 
\code{matches("my_col_name")}. To match a logical vector, convert it to a column index using
\code{\link{which}}.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
Subsets \code{taxon_data} columns in a \code{\link{taxmap}} object. Takes and returns a
\code{\link{taxmap}} object. Any column name that appears in \code{taxon_data(.data)} can be
used as if it was a vector on its own. See \code{\link[dplyr]{select}} for more information.
}
\examples{
# subset taxon columns
select_taxa(unite_ex_data_3, name)
  
}
\seealso{
Other dplyr-like functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{filter_taxa}}, \code{\link{mutate_obs}},
  \code{\link{mutate_taxa}}, \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{transmute_obs}},
  \code{\link{transmute_taxa}}
}

