% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--mutate.R
\name{transmute_obs}
\alias{transmute_obs}
\title{Replace columns in \code{\link{taxmap}} objects}
\usage{
transmute_obs(.data, ...)
}
\arguments{
\item{.data}{\code{\link{taxmap}}}

\item{...}{One or more column names to add to the new object. Newly created columns can be
referenced in the same function call.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
Replace columns of \code{obs_data} in \code{\link{taxmap}} objects. Any column name that
appears in \code{obs_data(.data)} can be used as if it was a vector on its own. See
\code{\link[dplyr]{transmute}} for inspiration and more information.
}
\examples{
# Replace all observation columns with new columns
transmute_obs(unite_ex_data_3, x = 1, y = x+2)
  
}
\seealso{
Other dplyr-like functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{filter_taxa}}, \code{\link{mutate_obs}},
  \code{\link{mutate_taxa}}, \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{select_taxa}},
  \code{\link{transmute_taxa}}
}

