% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--sample.R
\name{sample_frac_taxa}
\alias{sample_frac_taxa}
\title{Sample a proportion of taxa from \code{\link{taxmap}}}
\usage{
sample_frac_taxa(.data, size = 1, taxon_weight = NULL, obs_weight = NULL,
  use_subtaxa = TRUE, collapse_func = mean, ...)
}
\arguments{
\item{.data}{(\code{\link{taxmap}}) The object to sample from.}

\item{size}{(\code{numeric} of length 1) The proportion of taxa to sample.}

\item{taxon_weight}{(\code{numeric}) Non-negative sampling weights of each taxon. The expression 
given is evaluated in the context of \code{\link{taxon_data}}. In other words, any column name 
that appears in \code{\link{taxon_data}(.data)} can be used as if it was a vector on its own. 
If \code{obs_weight} is also specified, the two weights are multiplied (after 
\code{obs_weight} for each taxon is calculated).}

\item{obs_weight}{(\code{numeric}) Sampling weights of each observation. The weights for each observation 
assigned to a given taxon are supplied to \code{collapse_func} to get the taxon weight. If 
\code{use_subtaxa} is \code{TRUE} then the observations assigned to every subtaxa are also used. The 
expression given is evaluated in the context of \code{\link{obs_data}}. In other words, any 
column name that appears in \code{\link{obs_data}(.data)} can be used as if it was a vector on
its own. If \code{taxon_weight} is also specified, the two weights are multiplied (after 
\code{obs_weight} for each observation is calculated).}

\item{use_subtaxa}{(\code{logical} of length 1) Affects how the \code{obs_weight} option is
used. If \code{TRUE}, the weights for each taxon in an observation's classification are multiplied to
get the observation weight. Otherwise, just the taxonomic level the observation is assign to it considered.}

\item{collapse_func}{(\code{function} of length 1) If \code{taxon_weight} is used and 
\code{supertaxa} is \code{TRUE}, the weights for each taxon in an observation's classification are 
supplied to \code{collapse_func} to get the observation weight. This function should take  numeric 
vector and return a single number.}

\item{...}{Additional options are passed to \code{\link{filter_taxa}}.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
Randomly sample some proportion of taxa from a \code{\link{taxmap}} object. Weights can be 
specified for taxa or the observations assigned to them. See \link[dplyr]{sample_frac} for the
inspiration for this function.
}
\examples{
# subsample taxa, preserving shared supertaxa
sample_frac_taxa(unite_ex_data_3, 0.1, supertaxa = TRUE)
# subsample taxa using weights, preserving subtaxa
sample_frac_taxa(unite_ex_data_3, 0.01, subtaxa = TRUE,
                 taxon_weight = ifelse(unite_rank == "g" & n_subtaxa > 3, 1, 0))
              
}
\seealso{
Other dplyr-like functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{filter_taxa}}, \code{\link{mutate_obs}},
  \code{\link{mutate_taxa}}, \code{\link{sample_frac_obs}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{select_taxa}},
  \code{\link{transmute_obs}}, \code{\link{transmute_taxa}}
}
