% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_phyloseq}
\alias{parse_phyloseq}
\title{Convert a phyloseq to taxmap}
\usage{
parse_phyloseq(obj)
}
\arguments{
\item{obj}{A phyloseq object}
}
\value{
A taxmap object
}
\description{
Converts a phyloseq object to a taxmap object.
}
\examples{
\dontrun{

# Install phyloseq to get example data
# source('http://bioconductor.org/biocLite.R')
# biocLite('phyloseq')

# Parse example dataset
library(phyloseq)
data(GlobalPatterns)
x <- parse_phyloseq(GlobalPatterns)

# Plot data
heat_tree(x,
          node_size = n_obs,
          node_color = n_obs,
          node_label = taxon_names,
          tree_label = taxon_names)

}

}
\seealso{
Other parsers: \code{\link{parse_greengenes}},
  \code{\link{parse_mothur_tax_summary}},
  \code{\link{parse_mothur_taxonomy}},
  \code{\link{parse_newick}}, \code{\link{parse_phylo}},
  \code{\link{parse_qiime_biom}}, \code{\link{parse_rdp}},
  \code{\link{parse_silva_fasta}},
  \code{\link{parse_unite_general}}
}
