% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{write_silva_fasta}
\alias{write_silva_fasta}
\title{Write an imitation of the SILVA FASTA database}
\usage{
write_silva_fasta(obj, file,
  tax_names = obj$get_data("taxon_names")[[1]],
  other_names = obj$get_data("other_name")[[1]],
  ids = obj$get_data("ncbi_id")[[1]],
  start = obj$get_data("start_pos")[[1]],
  end = obj$get_data("end_pos")[[1]],
  sequences = obj$get_data("silva_seq")[[1]])
}
\arguments{
\item{obj}{A taxmap object}

\item{file}{(\code{character} of length 1) The file path to save the
sequence fasta file. This is optional.}

\item{tax_names}{(\code{character} named by taxon ids) The names of taxa}

\item{other_names}{(\code{character} named by taxon ids) Alternate names
of taxa. Will be added after the primary name.}

\item{ids}{(\code{character} named by taxon ids) Sequence ids}

\item{start}{(\code{character}) The start position of the
sequence.}

\item{end}{(\code{character}) The end position of the
sequence.}

\item{sequences}{(\code{character} named by taxon ids) Sequences}
}
\description{
Attempts to save taxonomic and sequence information of a taxmap object in the
SILVA FASTA format. If the taxmap object was created using
\code{\link{parse_silva_fasta}}, then it should be able to replicate the format
exactly with the default settings.
}
\details{
The output file has a format like:

\preformatted{
>GCVF01000431.1.2369 Bacteria;Proteobacteria;Gammaproteobacteria;Oceanospiril...
CGUGCACGGUGGAUGCCUUGGCAGCCAGAGGCGAUGAAGGACGUUGUAGCCUGCGAUAAGCUCCGGUUAGGUGGCAAACA
ACCGUUUGACCCGGAGAUCUCCGAAUGGGGCAACCCACCCGUUGUAAGGCGGGUAUCACCGACUGAAUCCAUAGGUCGGU
...
}
}
\seealso{
Other writers: \code{\link{make_dada2_asv_table}},
  \code{\link{make_dada2_tax_table}},
  \code{\link{write_greengenes}},
  \code{\link{write_mothur_taxonomy}},
  \code{\link{write_rdp}},
  \code{\link{write_unite_general}}
}
\concept{writers}
