% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option_parsers.R
\name{get_taxmap_cols}
\alias{get_taxmap_cols}
\title{Get a column subset}
\usage{
get_taxmap_cols(obj, data, cols = NULL)
}
\arguments{
\item{obj}{A taxmap object}

\item{data}{The name of a table in \code{obj} that contains counts.}

\item{cols}{The columns in the data set to use. Takes one of
the following inputs:
\describe{
  \item{TRUE/FALSE:}{All non-target columns will be preserved or not.}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns
corresponding to \code{TRUE} values.}
  \item{Character vector:}{The names of columns to preserve}
  \item{Numeric vector:}{The indexes of columns to preserve}
}}
}
\description{
Convert logical, names, or indexes to column names and check that they exist.
}
\examples{
\dontrun{
# Parse data
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "taxon_rank", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")
                   
# Get all col names
metacoder:::parse_taxmap_cols(x, "tax_data")

# Get col names by index
metacoder:::parse_taxmap_cols(x, "tax_data", 2:4)

# Get col names by name (i.e. verify)
metacoder:::parse_taxmap_cols(x, "tax_data", c("taxon_id", "lineage"))
metacoder:::parse_taxmap_cols(x, "tax_data", c("taxon_id", "not_valid"))

# Get colnames by TRUE/FALSE vector
metacoder:::parse_taxmap_cols(x, "tax_data", startsWith(colnames(x$data$tax_data), "7"))
                   
}
}
\seealso{
Other option parsers: 
\code{\link{get_taxmap_data}()},
\code{\link{get_taxmap_other_cols}()},
\code{\link{get_taxmap_table}()},
\code{\link{verify_taxmap}()}
}
\concept{option parsers}
\keyword{internal}
