% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nebs.R
\name{neb}
\alias{neb}
\title{Find transition path on free energy surface by Nudged Elastic Band method}
\usage{
neb(minims = minims, min1 = "A", min2 = "B", nbins = 20,
  nsteps = 100, step = 1, k = 0.2)
}
\arguments{
\item{minims}{minima object.}

\item{min1}{starting minimum identifier (can be letter or
index, default "A").}

\item{min2}{final minimum identifier (can be letter or index,
default "B").}

\item{nbins}{number of bins along Nudged Elastic Band (default 20).}

\item{nsteps}{number of Nudged Elastic Band iterations (default 100).}

\item{step}{Nudged Elastic Band iteration step (default 1).}

\item{k}{Nudged Elastic Band toughness (default 0.2).}
}
\value{
NEB path
}
\description{
`neb` finds a transition path on free energy surface for a given pair of
minima. For a 1D surface it simply takes the free energy profile between the
two minima. For 2D surface it calculates the transition path by Nudged Elastic
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
nebAD<-neb(minima, min1="A", min2="D", nsteps=20)
nebAD
}
