% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{add_plan}
\alias{add_plan}
\title{Add additional analysis plan}
\usage{
add_plan(plan, analysis, population, observation, parameter, ...)
}
\arguments{
\item{plan}{A \code{meta_plan} object.}

\item{analysis}{A character value of analysis term name.
The term name is used as key to link information.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{observation}{A character value of observation term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{...}{Additional arguments.}
}
\value{
A data frame containing analysis plans with new plans added.
}
\description{
Add additional analysis plan
}
\examples{
plan("ae_summary",
  population = "apat",
  observation = c("wk12", "wk24"), parameter = "any;rel"
) |>
  add_plan("ae_specific",
    population = "apat",
    observation = c("wk12", "wk24"), parameter = c("any", "rel")
  )
}
