% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvmeta.r
\name{rmplot.uvmeta}
\alias{rmplot.uvmeta}
\title{Plot the running means of a Bayesian meta-analysis model}
\usage{
\method{rmplot}{uvmeta}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"valmeta"}}

\item{\ldots}{Additional arguments which are currently not used}
}
\value{
A \code{ggplot} object.

An object of class \code{ggplot}
}
\description{
Function to display running means of a fitted Bayesian meta-analysis model.
}
\details{
Results are displayed for the estimated mean (\code{mu}) and standard-deviation (\code{tau}) of the meta-analysis model.
}
\examples{
\dontrun{
data(Roberts)

fit <- with(Roberts, uvmeta(r=SDM, r.se=SE, labels=rownames(Roberts), method="BAYES"))
rmplot(fit)
} 

}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{convergence}
\keyword{meta-analysis}
