% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_coef.R
\name{plot.corr_coef}
\alias{plot.corr_coef}
\title{Create a correlation heat map}
\usage{
\method{plot}{corr_coef}(
  x,
  type = "lower",
  diag = FALSE,
  reorder = TRUE,
  signif = "stars",
  caption = TRUE,
  digits.cor = 2,
  digits.pval = 3,
  col.low = "blue",
  col.mid = "white",
  col.high = "red",
  lab.x.position = NULL,
  lab.y.position = NULL,
  legend.position = NULL,
  legend.title = "Pearson's\\nCorrelation",
  size.text.cor = 3,
  size.text.signif = 3,
  size.text.lab = 10,
  ...
)
}
\arguments{
\item{x}{The data set.}

\item{type}{The type of heat map to produce. Either \code{lower} (default) to
produce a lower triangle heat map or \code{upper} to produce an upper
triangular heat map.}

\item{diag}{Plot diagonal elements? Defaults to \code{FALSE}.}

\item{reorder}{Reorder the correlation matrix to identify the hidden pattern?
Defaults to \code{TRUE}.}

\item{signif}{How to show significant correlations. If \code{"stars"} is used
(default), stars are used showing the significance at 0.05 ("\emph{"), 0.01
("\strong{") and 0.001 ("}}") probability error. If \code{signif = "pval"}, then
the p-values are shown.}

\item{caption}{Logical. If \code{TRUE} (Default) includes a caption with the
significance meaning for stars.}

\item{digits.cor, digits.pval}{The significant digits to show for correlations
and p-values, respectively.}

\item{col.low, col.mid, col.high}{The color for the low (-1), mid(0) and high
(1) points in the color key. Defaults to \code{blue}, \code{white}, and
\code{red}, respectively.}

\item{lab.x.position, lab.y.position}{The position of the x and y axis label.
Defaults to \code{"bottom"} and \code{"right"} if \code{type = "lower"} or
\code{"top"} and \code{"left"} if \code{type = "upper"}.}

\item{legend.position}{The legend position in the plot.}

\item{legend.title}{The title of the color key. Defaults to \code{"Pearson's Correlation"}.}

\item{size.text.cor}{The size of the text for correlation values. Defaults to 3.}

\item{size.text.signif}{The size of the text for significance values (stars or p-values). Defaults to 3.}

\item{size.text.lab}{The size of the text for labels. Defaults to 10.}

\item{...}{Currently not used.}
}
\value{
An object of class \verb{gg, ggplot}
}
\description{
Create a correlation heat map for object of class \code{corr_coef}
}
\examples{
\donttest{
library(metan)
# All numeric variables
all <- corr_coef(data_ge2)
plot(all)
plot(all, reorder = FALSE)

# Select variables
sel <- corr_coef(data_ge2, EP, EL, CD, CL)
plot(sel,
     type = "upper",
     reorder = FALSE,
     size.text.lab = 14,
     size.text.plot = 5)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
