% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utils_mat}
\alias{utils_mat}
\alias{make_upper_tri}
\alias{make_lower_tri}
\alias{make_lower_upper}
\alias{make_sym}
\alias{tidy_sym}
\title{Utilities for handling with matrices}
\usage{
make_upper_tri(x, diag = NA)

make_lower_tri(x, diag = NA)

make_lower_upper(lower, upper, diag = NA)

make_sym(x, make = "upper", diag = NA)

tidy_sym(x, keep_diag = TRUE)
}
\arguments{
\item{x}{A matrix to apply the function. It must be a symmetric (square)
matrix in \code{make_upper_tri()} and \code{make_lower_tri()} or a
triangular matrix in \code{make_sym()}. \code{tidy_sym()} accepts both
symmetrical or triangular matrices.}

\item{diag}{What show in the diagonal of the matrix. Default to \code{NA}.}

\item{lower}{A square matrix to fill the lower diagonal of the new matrix.}

\item{upper}{A square matrix to fill the upper diagonal of the new matrix.}

\item{make}{The triangular to built. Default is \code{"upper"}. In this case,
a symmetric matrix will be built based on the values of a lower triangular
matrix.}

\item{keep_diag}{Keep diagonal values in the tidy data frame? Defaults to
\code{TRUE}.}
}
\value{
An upper, lower, or symmetric matrix, or a tidy data frame.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions help users to make upper, lower, or symmetric matrices
easily.
}
\details{
\itemize{
\item \code{make_upper_tri()} makes an upper triangular matrix using a symmetric
matrix.
\item \code{make_lower_tri()} makes a lower triangular matrix using a symmetric
matrix.
\item \code{make_sym()} makes a lower triangular matrix using a symmetric matrix.
\item \code{tidy_sym()} transform a symmetric matrix into tidy data frame.
}
}
\examples{
\donttest{
library(metan)
m <- cor(select_cols(data_ge2, 5:10))
make_upper_tri(m)
make_lower_tri(m)
make_lower_tri(m) \%>\%
make_sym(diag = 0)
tidy_sym(m)
tidy_sym(make_lower_tri(m))

}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
