% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_stats.R
\name{print.ge_stats}
\alias{print.ge_stats}
\title{Print an object of class ge_stats}
\usage{
\method{print}{ge_stats}(x, what = "all", export = FALSE, file.name = NULL, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{ge_stats}.}

\item{what}{What should be printed. \code{what = "all"} for both statistics
and ranks, \code{what = "stats"} for statistics, and \code{what = "ranks"}
for ranks.}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported to
the working directory.}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print the \code{ge_stats} object in two ways. By default, the results are
shown in the R console. The results can also be exported to the directory
into a *.txt file.
}
\examples{
\donttest{
library(metan)
model <- ge_stats(data_ge, ENV, GEN, REP, GY)
print(model)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
