% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamem_met.R
\name{gamem_met}
\alias{gamem_met}
\title{Genotype-environment analysis by mixed-effect models}
\usage{
gamem_met(
  .data,
  env,
  gen,
  rep,
  resp,
  block = NULL,
  random = "gen",
  prob = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure a vector of variables may be used. For example \code{resp
  = c(var1, var2, var3)}.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then an alpha-lattice
design is employed considering block as random to make use of inter-block
information, whereas the complete replicate effect is always taken as
fixed, as no inter-replicate information was to be recovered (Mohring et
al., 2015).}

\item{random}{The effects of the model assumed to be random. Defaults to
\code{random = "gen"}. See \strong{Details} to see the random effects
assumed depending on the experimental design of the trials.}

\item{prob}{The probability for estimating confidence interval for BLUP's
prediction.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{waasb} with the following items for each
variable:
\itemize{
\item \strong{fixed} Test for fixed effects.
\item \strong{random} Variance components for random effects.
\item \strong{LRT} The Likelihood Ratio Test for the random effects.
\item \strong{BLUPgen} The random effects and estimated BLUPS for genotypes (If
\code{random = "gen"} or \code{random = "all"})
\item \strong{BLUPenv} The random effects and estimated BLUPS for environments,
(If \code{random = "env"} or \code{random = "all"}).
\item \strong{BLUPint} The random effects and estimated BLUPS of all genotypes in
all environments.
\item \strong{MeansGxE} The phenotypic means of genotypes in the environments.
\item \strong{Details} A list summarizing the results. The following information
are shown: \code{Nenv}, the number of environments in the analysis;
\code{Ngen} the number of genotypes in the analysis; \code{Mean} the grand
mean; \code{SE} the standard error of the mean; \code{SD} the standard
deviation. \code{CV} the coefficient of variation of the phenotypic means,
estimating WAASB, \code{Min} the minimum value observed (returning the
genotype and environment), \code{Max} the maximum value observed (returning
the genotype and environment); \code{MinENV} the environment with the lower
mean, \code{MaxENV} the environment with the larger mean observed,
\code{MinGEN} the genotype with the lower mean, \code{MaxGEN} the genotype
with the larger.
\item \strong{ESTIMATES} A tibble with the genetic parameters (if \code{random =
"gen"} or \code{random = "all"}) with the following columns: \code{Phenotypic
variance} the phenotypic variance; \code{Heritability} the broad-sense
heritability; \code{GEr2} the coefficient of determination of the interaction
effects; \code{Heribatility of means} the heritability on the mean basis;
\code{Accuracy} the selective accuracy; \code{rge} the genotype-environment
correlation; \code{CVg} the genotypic coefficient of variation; \code{CVr}
the residual coefficient of variation; \code{CV ratio} the ratio between
genotypic and residual coefficient of variation.
\item \strong{residuals} The residuals of the model.
}
}
\description{
Genotype analysis in multi-environment trials using mixed-effect or
random-effect models.
}
\details{
The nature of the effects in the model is chosen with the argument
\code{random}. By default, the experimental design considered in each
environment is a randomized complete block design. If \code{block} is
informed, a resolvable alpha-lattice design (Patterson and Williams, 1976) is
implemented. The following six models can be fitted depending on the values
of \code{random} and \code{block} arguments.
\itemize{
\item \strong{Model 1:} \code{block = NULL} and \code{random = "gen"} (The
default option). This model considers a Randomized Complete Block Design in
each environment assuming genotype and genotype-environment interaction as
random effects. Environments and blocks nested within environments are
assumed to fixed factors.
\item \strong{Model 2:} \code{block = NULL} and \code{random = "env"}. This
model considers a Randomized Complete Block Design in each environment
treating environment, genotype-environment interaction, and blocks nested
within environments as random factors. Genotypes are assumed to be fixed
factors.
\item \strong{Model 3:} \code{block = NULL} and \code{random = "all"}. This
model considers a Randomized Complete Block Design in each environment
assuming a random-effect model, i.e., all effects (genotypes, environments,
genotype-vs-environment interaction and blocks nested within environments)
are assumed to be random factors.
\item \strong{Model 4:} \code{block} is not \code{NULL} and \code{random =
  "gen"}. This model considers an alpha-lattice design in each environment
assuming genotype, genotype-environment interaction, and incomplete blocks
nested within complete replicates as random to make use of inter-block
information (Mohring et al., 2015). Complete replicates nested within
environments and environments are assumed to be fixed factors.
\item \strong{Model 5:} \code{block} is not \code{NULL} and \code{random =
  "env"}. This model considers an alpha-lattice design in each environment
assuming genotype as fixed. All other sources of variation (environment,
genotype-environment interaction, complete replicates nested within
environments, and incomplete blocks nested within replicates) are assumed
to be random factors.
\item \strong{Model 6:} \code{block} is not \code{NULL} and \code{random =
  "all"}. This model considers an alpha-lattice design in each environment
assuming all effects, except the intercept, as random factors.
}
}
\examples{
\donttest{
library(metan)
#===============================================================#
# Example 1: Analyzing all numeric variables assuming genotypes #
# as random effects                                             #
#===============================================================#
model <- gamem_met(data_ge,
                  env = ENV,
                  gen = GEN,
                  rep = REP,
                  resp = everything())
# Distribution of random effects (first variable)
plot(model, type = "re")

# Genetic parameters
get_model_data(model, "genpar")



#===============================================================#
# Example 2: Unbalanced trials                                  #
# assuming all factors as random effects                        #
#===============================================================#
un_data <- data_ge \%>\%
             remove_rows(1:3) \%>\%
             droplevels()

model2 <- gamem_met(un_data,
                   env = ENV,
                   gen = GEN,
                   rep = REP,
                   random = "all",
                   resp = GY)
get_model_data(model2)
}

}
\references{
Olivoto, T., A.D.C. L{\'{u}}cio, J.A.G. da silva, V.S. Marchioro, V.Q. de
Souza, and E. Jost. 2019. Mean performance and stability in multi-environment
trials I: Combining features of AMMI and BLUP techniques. Agron. J.
111:2949-2960.
\href{https://acsess.onlinelibrary.wiley.com/doi/abs/10.2134/agronj2019.03.0220}{doi:10.2134/agronj2019.03.0220}

Mohring, J., E. Williams, and H.-P. Piepho. 2015. Inter-block information: to
recover or not to recover it? TAG. Theor. Appl. Genet. 128:1541-54.
\href{http://www.ncbi.nlm.nih.gov/pubmed/25972114}{doi:10.1007/s00122-015-2530-0}

Patterson, H.D., and E.R. Williams. 1976. A new class of resolvable
incomplete block designs. Biometrika 63:83-92.
\href{https://doi.org/10.1093/biomet/63.1.83}{doi:10.1093/biomet/63.1.83}
}
\seealso{
\code{\link{mtsi}} \code{\link{waas}}
\code{\link{get_model_data}} \code{\link{plot_scores}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
