% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fai_blup.R
\name{fai_blup}
\alias{fai_blup}
\title{Multi-trait selection index}
\usage{
fai_blup(
  .data,
  use_data = "blup",
  DI = NULL,
  UI = NULL,
  SI = 15,
  mineval = 1,
  verbose = TRUE
)
}
\arguments{
\item{.data}{An object of class \code{waasb} or a two-way table with
genotypes in the rows and traits in columns. In the last case the row names
must contain the genotypes names.}

\item{use_data}{Define which data to use If \code{.data} is an object of
class \code{gamem}. Defaults to \code{"blup"} (the BLUPs for genotypes).
Use \code{"pheno"} to use phenotypic means instead BLUPs for computing the
index.}

\item{DI, UI}{A vector of the same length of \code{.data} to construct the
desirable (DI) and undesirable (UI) ideotypes. For each element of the
vector, allowed values are \code{'max'}, \code{'min'}, \code{'mean'}, or a
numeric value. Use a comma-separated vector of text. For example, \code{DI
  = c("max, max, min, min")}. By default, DI is set to \code{"max"} for all
traits and UI is set to \code{"min"} for all traits.}

\item{SI}{An integer (0-100). The selection intensity in percentage of the
total number of genotypes. Defaults to 15.}

\item{mineval}{The minimum value so that an eigenvector is retained in the
factor analysis.}

\item{verbose}{Logical value. If \code{TRUE} some results are shown in
console.}
}
\value{
An object of class \code{fai_blup} with the following items:
\itemize{
\item \strong{data} The data (BLUPS) used to compute the index.
\item \strong{eigen} The eigenvalues and explained variance for each axis.
\item \strong{FA} The results of the factor analysis.
\item \strong{canonical_loadings} The canonical loadings for each factor retained.
\item \strong{FAI} A list with the FAI-BLUP index for each ideotype design.
\item \strong{selection_diferential} A list with the selection differential for each ideotype design.
\item \strong{sel_gen} The selected genotypes.
\item \strong{ideotype_construction} A list with the construction of the ideotypes.
\item \strong{total_gain} A list with the total gain for variables to be increased or decreased.
}
}
\description{
Multitrait index based on factor analysis and ideotype-design proposed by
Rocha et al. (2018).
}
\examples{
\donttest{
library(metan)

mod <- waasb(data_ge,
             env = ENV,
             gen = GEN,
             rep = REP,
             resp = c(GY, HM))

FAI <- fai_blup(mod,
                SI = 15,
                DI = c('max, max'),
                UI = c('min, min'))
}
}
\references{
Rocha, J.R.A.S.C.R, J.C. Machado, and P.C.S. Carneiro. 2018. Multitrait index
based on factor analysis and ideotype-design: proposal and application on
elephant grass breeding for bioenergy. GCB Bioenergy 10:52-60.
\doi{10.1111/gcbb.12443}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
