% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_metrics_list.R
\name{generate_distance_metrics_list}
\alias{generate_distance_metrics_list}
\title{Generate a list of distance metrics}
\usage{
generate_distance_metrics_list(
  continuous_distances = NULL,
  discrete_distances = NULL,
  ordinal_distances = NULL,
  categorical_distances = NULL,
  mixed_distances = NULL,
  keep_defaults = TRUE
)
}
\arguments{
\item{continuous_distances}{A named list of distance metric functions}

\item{discrete_distances}{A named list of distance metric functions}

\item{ordinal_distances}{A named list of distance metric functions}

\item{categorical_distances}{A named list of distance metric functions}

\item{mixed_distances}{A named list of distance metric functions}

\item{keep_defaults}{If TRUE (default), prepend the base distance metrics
(euclidean and standard normalized euclidean)}
}
\value{
distance_metrics_list A well-formatted list of distance metrics
}
\description{
This function can be used to specify custom distance metrics
}
\examples{
# Using just the base distance metrics  ------------------------------------
distance_metrics_list <- generate_distance_metrics_list()

# Adding your own metrics --------------------------------------------------
# This will contain the base and user-provided clustering algorithms
my_distance_metric <- function(df) {
    # your code that converts a dataframe to a distance metric here...
    # return(distance_metric)
}

distance_metrics_list <- generate_distance_metrics_list(
    continuous_distances = list(
         "my_distance_metric" = my_distance_metric
    )
)

# Suppress the base metrics-------------------------------------------------
# This will contain only user-provided clustering algorithms

distance_metrics_list <- generate_distance_metrics_list(
    continuous_distances = list(
         "my_distance_metric" = my_distance_metric
    ),
    discrete_distances = list(
         "my_distance_metric" = my_distance_metric
    ),
    ordinal_distances = list(
         "my_distance_metric" = my_distance_metric
    ),
    categorical_distances = list(
         "my_distance_metric" = my_distance_metric
    ),
    mixed_distances = list(
         "my_distance_metric" = my_distance_metric
    ),
    keep_defaults = FALSE
)

}
