% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solutions_df.R
\name{get_pvals}
\alias{get_pvals}
\title{Get p-values from an extended solutions data frame}
\usage{
get_pvals(ext_sol_df, negative_log = FALSE, keep_summaries = TRUE)
}
\arguments{
\item{ext_sol_df}{The output of \code{extend_solutions}. A
data frame that contains at least one p-value column ending in "_pval".}

\item{negative_log}{If TRUE, will replace p-values with negative log
p-values.}

\item{keep_summaries}{If FALSE, will remove the mean, min, and max p-value.}
}
\value{
A "data.frame" class object Of only the p-value related columns
of the provided ext_sol_df.
}
\description{
This function can be used to neatly format the p-values associated with an
extended solutions data frame. It can also calculate the negative logs of those
p-values to make it easier to interpret large-scale differences.
}
