% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/residuals.meteDist.R
\name{residuals.meteDist}
\alias{residuals.meteDist}
\title{Compute residuals between METE predictions and date of a meteDist object}
\usage{
\method{residuals}{meteDist}(object, type = c("rank", "cumulative"),
  relative = TRUE, log = FALSE, ...)
}
\arguments{
\item{object}{a \code{meteDist} object}

\item{type}{'rank' or 'cumulative'}

\item{relative}{logical; if true use relative MSE}

\item{log}{logical; if TRUE calculate MSE on logged distirbution. If FALSE use arithmetic scale.}

\item{...}{arguments to be passed to methods}
}
\value{
a numeic vector giving residuals for each data point
}
\description{
\code{residuals.meteDist} computes residuals between METE predictions and
data of a meteDist object
}
\details{
See Examples. Typically not called directly by the user and rather used for
calculating the mean square error with \code{mse.meteDist}. If \code{type='rank'}
returned value will be of length equal to number of observations (e.g. number of
species in case of SAD) but if \code{type='cumulative'} returned value will be of
length equal to number of unique ovservations (e.g. number of unique abundances in
case of SAR).
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
sad1 <- sad(esf1)
residuals(sad1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
\code{mse.meteDist}
}

