plot.interpolation.cv<-function(x, type="stations",...) {
  if(type =="stations") {
    stationsdf = x$stations
    par(mfrow=c(3,4), mar=c(4,4,2,2))
    hist(stationsdf$`MinTemperature.Bias`, xlab="Min. temp. bias (degrees C)", main="",...)
    abline(v=mean(stationsdf$`MinTemperature.Bias`, na.rm=TRUE), col="gray", lwd=2)
    abline(v=0, col="red", lwd=2)
    hist(stationsdf$`MinTemperature.MAE`, xlab="Min. temp. MAE (degrees C)", main="",...)
    abline(v=mean(stationsdf$`MinTemperature.MAE`, na.rm=TRUE), col="gray", lwd=2)
    hist(stationsdf$`MaxTemperature.Bias`, xlab="Max. temp. bias (degrees C)", main="",...)
    abline(v=mean(stationsdf$`MaxTemperature.Bias`, na.rm=TRUE), col="gray", lwd=2)
    abline(v=0, col="red", lwd=2)
    hist(stationsdf$`MaxTemperature.MAE`, xlab="Max. temp. MAE (degrees C)", main="")
    abline(v=mean(stationsdf$`MaxTemperature.MAE`, na.rm=TRUE), col="gray", lwd=2)
    hist(stationsdf$TotalPrec.Pred - stationsdf$TotalPrec.Obs, xlab="Error in total precipitation (mm)", main="",...)
    abline(v=mean(stationsdf$TotalPrec.Pred - stationsdf$TotalPrec.Obs, na.rm=TRUE), col="gray", lwd=2)
    abline(v=0, col="red", lwd=2)
    hist(stationsdf$PrecFreq.Pred - stationsdf$PrecFreq.Obs, xlab="Error in proportion of rainy days (%)", main="",...)
    abline(v=mean(stationsdf$PrecFreq.Pred - stationsdf$PrecFreq.Ob, na.rm=TRUE), col="gray", lwd=2)
    abline(v=0, col="red", lwd=2)
    hist(stationsdf$`RelativeHumidity.Bias`, xlab= "RelativeHumidity Bias (%)", main="",...)
    abline(v=mean(stationsdf$`RelativeHumidity.Bias`, na.rm=TRUE), col="gray", lwd=2)
    abline(v=0, col="red", lwd=2)
    hist(stationsdf$`RelativeHumidity.MAE`, xlab= "RelativeHumidity MAE (%)", main="",...)
    abline(v=mean(stationsdf$`RelativeHumidity.MAE`, na.rm=TRUE), col="gray", lwd=2)
    hist(stationsdf$`Radiation.Bias`, xlab= "Radiation Bias (MJ/m2)", main="",...)
    abline(v=mean(stationsdf$`Radiation.Bias`, na.rm=TRUE), col="gray", lwd=2)
    abline(v=0, col="red", lwd=2)
    hist(stationsdf$`Radiation.MAE`, xlab= "Radiation MAE (MJ/m2)", main="",...)
    abline(v=mean(stationsdf$`Radiation.MAE`, na.rm=TRUE), col="gray", lwd=2)
  } else if(type=="dates") {
    datesdf = x$dates
    par(mfrow=c(5,2), mar=c(4,4,2,2))
    plot(datesdf$`MinTemperature.Bias`, type="l", ylab="Min. temp. bias (degrees C)", xlab="day", main="",...)
    abline(h=0, col="red", lwd=1.5)
    plot(datesdf$`MinTemperature.MAE`, type="l", ylab="Min. temp. MAE (degrees C)", xlab="day", main="",...)
    plot(datesdf$`MaxTemperature.Bias`, type="l", ylab="Max. temp. bias (degrees C)", xlab="day", main="",...)
    abline(h=0, col="red", lwd=1.5)
    plot(datesdf$`MaxTemperature.MAE`, type="l", ylab="Max. temp. MAE (degrees C)", xlab="day", main="",...)
    plot(datesdf$TotalPrec.Pred - datesdf$TotalPrec.Obs, type="l", ylab="Error in daily total precipitation (mm)", xlab="day", main="",...)
    abline(h=0, col="red", lwd=1.5)
    plot(datesdf$PrecFreq.Pred - datesdf$PrecFreq.Obs, type="l", ylab="Error in frequency of wet stations (%)", xlab="day", main="",...)
    abline(h=0, col="red", lwd=1.5)
    plot(datesdf$`RelativeHumidity.Bias`, type="l", ylab="RelativeHumidity bias (%)", xlab="day", main="",...)
    abline(h=0, col="red", lwd=1.5)
    plot(datesdf$`RelativeHumidity.MAE`, type="l", ylab="RelativeHumidity MAE (%)", xlab="day", main="",...)
    plot(datesdf$`Radiation.Bias`, type="l", ylab="Radiation bias (MJ/m2)", xlab="day", main="",...)
    abline(h=0, col="red", lwd=1.5)
    plot(datesdf$`Radiation.MAE`, type="l", ylab="Radiation MAE (MJ/m2)", xlab="day", main="",...)
  } else stop("Wrong 'type'.")

}
