% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_main.R
\name{varevalue.metilene}
\alias{varevalue.metilene}
\title{Evalue of the Metilene data}
\usage{
varevalue.metilene(a, b, a_b, adjust.methods = "BH")
}
\arguments{
\item{a}{A data.frame object, the columns should be (in order):

chrom    pos    g1    g1    g1    g1    g1    g1    g1    g1    g2    g2    g2    g2    g2    g2    g2    g2

i.e two key columns (chrom, pos) with several value columns in groups.}

\item{b}{A data.frame object stores the data, the columns are (in order):

    - chr:   Chromosome

    - start: The positions of the start sites of the corresponding region

    - end: The positions of the end sites of the corresponding region

    - q-value: The adjusted p-value based on BH method in MWU-test

    - methyl.diff: The difference between the group means of methylation level

    - CpGs:  The number of CpG sites within the corresponding region

    - p : p-value based on MWU-test

    - p2: p-value based on 2D KS-test

    - m1:  The absolute mean methylation level for the corresponding segment of group 1

    - m2:  The absolute mean methylation level for the corresponding segment of group 2}

\item{a_b}{A data.frame object of a join b with particular data clean processes. Check the function [evalue.methylKit.chk()] for more details.}

\item{adjust.methods}{is the adjust methods of e-value. It can be 'bonferroni', 'hochberg', 'holm', 'hommel', 'BH', 'BY'. The default value is 'BH'.}
}
\value{
a dataframe, the columns are (in order):

    - chr:   Chromosome

    - start: The positions of the start sites of the corresponding region

    - end: The positions of the end sites of the corresponding region

    - q-value: The adjusted p-value based on BH method in MWU-test

    - methyl.diff: The difference between the group means of methylation level

    - CpGs:  The number of CpG sites within the corresponding region

    - p : p-value based on MWU-test

    - p2: p-value based on 2D KS-test

    - m1:  The absolute mean methylation level for the corresponding segment of group 1

    - m2:  The absolute mean methylation level for the corresponding segment of group 2

    - e_value: The e-value of the corresponding region
}
\description{
Perform the Evaluation for the Metilene data. The data file could be pre-handled by the evalue.metilene.chk function.
}
\examples{
#### methylKit example ####
data(demo_methylkit_methyrate)
data(demo_methylkit_met_all)
example_tempfiles = tempfile(c("rate_combine", "methylKit_DMR_raw"))
tempdir()
write.table(demo_methylkit_methyrate, file=example_tempfiles[1],
      row.names=FALSE, col.names=TRUE, quote=FALSE, sep='\t')
write.table (demo_methylkit_met_all, file=example_tempfiles[2],
      sep ="\t", row.names =FALSE, col.names =TRUE, quote =FALSE)
result = metevalue.methylKit(example_tempfiles[1], example_tempfiles[2],
      bheader = TRUE)
str(result)
}
