% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMetricsNnulls.R
\name{betaMetricsNnulls}
\alias{betaMetricsNnulls}
\title{Parallelized function that calculates beta metrics on randomized matrices}
\usage{
betaMetricsNnulls(tree, picante.cdm, optional.dists = NULL,
  regional.abundance = NULL, distances.among = NULL, randomizations = 2,
  cores = "seq", nulls, metrics)
}
\arguments{
\item{tree}{Phylo object}

\item{picante.cdm}{A picante-style community data matrix with sites as rows, and
species as columns}

\item{optional.dists}{A symmetric distance matrix can be directly supplied. This option
is experimental. Behavior depends on metric being used. If the metric in question
relies on the phylogenetic distance matrix from a call to cophenetic(tree), then this 
optional distance matrix will be inserted instead.}

\item{regional.abundance}{A character vector in the form "s1, s1, s1, s2, s2, s3, etc".
Optional, will be generated from the input CDM if not provided.}

\item{distances.among}{A symmetric distance matrix, summarizing the distances among all
plots from the cdm. Optional, only used by some null models.}

\item{randomizations}{The number of times the input CDM should be randomized and the
metrics calculated across it.}

\item{cores}{This function can run in parallel. In order to do so, the user must
specify the desired number of cores to utilize. The default is "seq", which runs the
calculations sequentially.}

\item{nulls}{Optional. If not provided, defines the nulls as all of those in
defineNulls. If only a subset of those is desired, then nulls should take
the form of a character vector corresponding to named functions from defineNulls.
The available nulls can be determined by running names(defineNulls()). Otherwise,
if the user would like to define a new null on the fly, the argument nulls can take
the form of a named list of new functions (nulls).}

\item{metrics}{Optional. If not provided, defines the metrics as all of those in
defineBetaMetrics. If only a subset of those is desired, then metrics should take
the form of a character vector corresponding to named functions from defineBetaMetrics.
The available metrics can be determined by running names(defineBetaMetrics()).
If the user would like to define a new metric on the fly, the argument can take
the form of a named list of new functions (metrics).}
}
\value{
A list of lists of vectors. The first level has as many elements as there
are randomizations. The second level has one list for each null model. Each element of
this second level is a named vector corresponding to the calculated metric at each
plot.
}
\description{
This function sends out jobs to as many cores as are specified. Each randomizes the
input CDM according to all defined null models, then calculates each observed beta
metric on each randomized matrix.
}
\details{
This function sends out jobs to as many cores as are specified. Each 
randomizes the input CDM according to all defined null models, then calculates each
observed metric on each randomized matrix.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

rawResults <- betaMetricsNnulls(tree, cdm, randomizations=3,
nulls=c("richness", "frequency"))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

