% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepSimulations.R
\name{prepSimulations}
\alias{prepSimulations}
\title{Prep data for spatial simulations}
\usage{
prepSimulations(tree, arena.length, mean.log.individuals, length.parameter,
  sd.parameter, max.distance, proportion.killed, competition.iterations)
}
\arguments{
\item{tree}{Phylo object}

\item{arena.length}{A numeric, specifying the length of a single side of the arena}

\item{mean.log.individuals}{Mean log of abundance vector from which species abundances
will be drawn}

\item{length.parameter}{Length of vector from which species' locations are drawn. Large
values of this parameter dramatically decrease the speed of the function but result in
nicer looking communities}

\item{sd.parameter}{Standard deviation of vector from which species' locations are 
drawn}

\item{max.distance}{The geographic distance within which neighboring
indivduals should be considered to influence the individual in question}

\item{proportion.killed}{The percent of individuals in the total arena that should be
considered (as a proportion, e.g. 0.5 = half)}

\item{competition.iterations}{Number of generations over which to run competition 
simulations}
}
\value{
A prepared simulations.input object
}
\description{
Given the required parameters for defined spatial simulations, will prepare an
object of class simulations.input for actual simulation.
}
\details{
This function preps the input for any of the spatial simulations as defined in
defineSimulations. If additional parameters are ever required for those simulations,
they would have to be added as additional arguments here.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
	length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
competition.iterations=3)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
