% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotContents.R
\name{plotContents}
\alias{plotContents}
\title{Identify individuals contained within a plot}
\usage{
plotContents(arena, plotPlacer.results)
}
\arguments{
\item{arena}{Data frame of three columns: "individuals", "X", and "Y"}

\item{plotPlacer.results}{The results of a call to plotPlacer. A list with two
elements. The first is a matrix of X Y coordinates of plots. The second is a
symmetrical distance matrix summarizing the distances among these plots.}
}
\value{
A matrix with species as rows and plots as columns.
}
\description{
Given a spatially explicit data frame of individual locations in a simulated arena,
and the bounds of a series of plots, identifies the contents of each plot.
}
\details{
Takes a data frame like that returned from filteringArena(), and a matrix
like that returned from plotPlacer(), and returns the resulting community data
matrix such as might be generated by someone surveying a forest plot. Plots with < 2
species are excluded from the CDM.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

temp <- evolveTraits(tree)

phydistmatrix <- ape::cophenetic.phylo(temp[[1]])

#define a color for each species
cols <- plotrix::color.scale(x=1:nrow(phydistmatrix),
cs1=c(0.2,0.4,0.8), cs2=c(0,0.5,0.8), cs3=c(1,0.5,0))

#prep the data for the simulation
prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
competition.iterations=3)

singleArena <- filteringArena(prepped)

#plot the arena. don't close the window
plot(singleArena$arena$X, singleArena$arena$Y, pch=20, cex=1, xlim=c(0,300), 
ylim=c(0,300), col=cols[singleArena$arena$individuals])

boundResults <- plotPlacer(no.plots=10, arena.length=300, plot.length=50)

plotPlotter(boundResults$plot.bounds)

#return a CDM in picante format
cdm <- plotContents(singleArena$arena, boundResults)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
