% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_RAC.R
\name{RAC}
\alias{RAC}
\title{Robinson's Agreement Coefficient (RAC).}
\usage{
RAC(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the agreement coefficient suggested by
Robinson (1957; 1959) for a continuous predicted-observed dataset.
}
\details{
The RAC measures both accuracy and precision (general agreement). It is
normalized, dimensionless, bounded (0 to 1), and symmetric (invariant to predicted-observed orientation).
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RAC(obs = X, pred = Y)
}
}
\references{
Robinson (1957).
The statistical measurement of agreement.
\emph{Am. Sociol. Rev. 22(1), 17-25} \doi{10.2307/2088760}

Robinson (1959).
The geometric interpretation of agreement.
\emph{Am. Sociol. Rev. 24(3), 338-345} \doi{10.2307/2089382}
}
