% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bus-schedule.R
\name{bus_schedule}
\alias{bus_schedule}
\title{Bus Schedule}
\format{
A data frame with 1 row per trip and 10 variables:
\describe{
\item{RouteID}{Bus route variant. This can be used in several other bus
methods which accept variants.}
\item{TripDirectionText}{General direction of the trip (NORTH, SOUTH, EAST,
WEST, LOOP, etc.).}
\item{TripHeadsign}{Descriptive text of where the bus is headed. This is
similar, but not necessarily identical, to what is displayed on the bus.}
\item{StartTime}{Scheduled start date and time (UTC) for this trip.}
\item{EndTime}{Scheduled end date and time (UTC) for this trip.}
\item{TripID}{Unique trip ID. This can be correlated with the data returned
from the schedule-related methods.}
\item{StopID}{7-digit regional ID which can be used in various bus-related
methods. If unavailable, the \code{StopID} will be 0 or \code{NA}}
\item{StopName}{Stop name. May be slightly different from what is spoken or
displayed in the bus.}
\item{StopSeq}{Order of the stop in the sequence of StopTimes.}
\item{Time}{Scheduled departure date and time (UTC) from this stop.}
}
}
\usage{
bus_schedule(
  RouteID,
  IncludingVariations = TRUE,
  Date = NULL,
  api_key = wmata_key()
)
}
\arguments{
\item{RouteID}{Bus route variant, e.g.: 70, 10A, 10Av1, etc.}

\item{IncludingVariations}{Whether or not to include variations if a base
route is specified in RouteID. For example, if B30 is specified and
\code{IncludingVariations} is set to \code{TRUE} (default), data for all variations
of B30 such as B30v1, B30v2, etc. will be returned.}

\item{Date}{(Optional) Date for which to retrieve route and stop information.}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
Data frame containing trip information
}
\description{
Returns schedules for a given route variant for a given date.
}
\examples{
\dontrun{
bus_schedule("70")
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/54763629281d83086473f231/operations/5476362a281d830c946a3d6b}

Other Bus Route and Stop Methods: 
\code{\link{bus_departs}()},
\code{\link{bus_path}()},
\code{\link{bus_position}()},
\code{\link{bus_routes}()},
\code{\link{bus_stops}()}
}
\concept{Bus Route and Stop Methods}
