% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivpot_methods.R
\name{ibvpot}
\alias{ibvpot}
\title{Interpret bivariate threshold exceedance models}
\usage{
ibvpot(fitted, q, silent = FALSE)
}
\arguments{
\item{fitted}{the output of \code{\link[evd]{fbvpot}} or a list. See Details.}

\item{q}{a vector of quantiles to consider, on the data scale. Must be greater than the thresholds.}

\item{silent}{boolean; whether to print the interpretation of the result. Default to \code{FALSE}.}
}
\value{
an invisible numeric vector containing marginal, joint and conditional exceedance probabilities.
}
\description{
This is an adaptation of the \pkg{evir} package \code{\link[evir]{interpret.gpdbiv}} function.
\code{interpret.fbvpot} was adapted to deal with the output of a call to
\code{\link[evd]{fbvpot}} from the \pkg{evd} and to handle families other than the logistic distribution.
The likelihood derivation comes from expression 2.10 in Smith et al. (1997).
}
\details{
The list \code{fitted} must contain
\itemize{
\item \code{model} a string; see \code{\link[evd]{bvevd}} for options
\item \code{param} a named vector containing the parameters of the \code{model}, as well as parameters
\code{scale1}, \code{shape1},\code{scale2} and \code{shape2}, corresponding to marginal GPD parameters.
\item \code{threshold} a vector of length 2 containing the two thresholds.
\item \code{pat} the proportion of observations above the corresponding \code{threshold}
}
}
\examples{
y <- evd::rgpd(1000,1,1,1)
x <- y*rmevspec(n=1000,d=2,sigma=cbind(c(0,0.5),c(0.5,0)),model="hr")
mod <- evd::fbvpot(x,threshold = c(1,1),model = "hr",likelihood ="censored")
ibvpot(mod, c(20,20))
}
\references{
Smith, Tawn and Coles (1997), Markov chain models for threshold exceedances. \emph{Biometrika},
\strong{84}(2), 249--268.
}
\seealso{
\code{\link[evir]{interpret.gpdbiv}}
}
\author{
Leo Belzile, adapting original S code by Alexander McNeil
}
