% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustering}
\alias{clustering}
\alias{clustering.default}
\alias{clustering.formula}
\title{Clustering Meta-features}
\usage{
clustering(...)

\method{clustering}{default}(
  x,
  y,
  features = "all",
  summary = c("mean", "sd"),
  transform = TRUE,
  ...
)

\method{clustering}{formula}(
  formula,
  data,
  features = "all",
  summary = c("mean", "sd"),
  transform = TRUE,
  ...
)
}
\arguments{
\item{...}{Further arguments passed to the summarization functions.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{transform}{A logical value indicating if the categorical attributes
should be transformed. If \code{FALSE} they will be ignored. (Default: 
\code{TRUE})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
Clustering measures extract information about validation index.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"vdu"}{Calculate the Dunn Index.}
   \item{"vdb"}{Calculate the Davies and Bouldin Index.}
   \item{"int"}{Calculate the INT index.}
   \item{"sil"}{Calculate the mean silhouette value from data.}
   \item{"pb"}{Pearson Correlation between class matching and instance 
     distances.}
   \item{"ch"}{Calinski and Harabaz index.}
   \item{"nre"}{Normalized relative entropy.}
   \item{"sc"}{Mean of the number of examples per class.}
 }
}
\examples{
## Extract all meta-features using formula
clustering(Species ~ ., iris)

## Extract some meta-features
clustering(iris[1:4], iris[5], c("vdu", "vdb", "sil"))

## Use another summarization function
clustering(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Bruno A. Pimentel, and Andre C. P. L. F. de Carvalho. A new data 
 characterization for selecting clustering algorithms using meta-learning. 
 Information Sciences, volume 477, pages 203 - 219, 2019.
}
\seealso{
Other meta-features: 
\code{\link{complexity}()},
\code{\link{concept}()},
\code{\link{general}()},
\code{\link{infotheo}()},
\code{\link{itemset}()},
\code{\link{landmarking}()},
\code{\link{model.based}()},
\code{\link{relative}()},
\code{\link{statistical}()}
}
\concept{meta-features}
