% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{mgc.sims.exp}
\alias{mgc.sims.exp}
\title{Exponential Simulation}
\usage{
mgc.sims.exp(n, d, eps = 10, ind = FALSE, a = 0, b = 3)
}
\arguments{
\item{n}{the number of samples for the simulation.}

\item{d}{the number of dimensions for the simulation setting.}

\item{eps}{the noise level for the simulation. Defaults to \code{10}.}

\item{ind}{whether to sample x and y independently. Defaults to \code{FALSE}.}

\item{a}{the lower limit for the range of the data matrix. Defaults to \code{0}.}

\item{b}{the upper limit for the range  of the data matrix. Defaults to \code{3}.}
}
\value{
a list containing the following:
\item{\code{X}}{\code{[n, d]} the data matrix with \code{n} samples in \code{d} dimensions.}
\item{\code{Y}}{\code{[n]} the response array.}
}
\description{
A function for Generating an exponential simulation.
}
\section{Details}{

Given: \eqn{w_i = \frac{1}{i}}{w[i] = 1/i} is a weight-vector that scales with the dimensionality.
Simulates \eqn{n} points from \eqn{Linear(X, Y) \in  \mathbf{R}^d \times \mathbf{R}}{Linear(X, Y)}, where:
\deqn{X \sim {U}(a, b)^d}{X ~ U(a, b)^d}
\deqn{Y = e^{w^TX} + \kappa \epsilon}{Y = exp(w^T X) + \kappa \epsilon}
and \eqn{\kappa = 1\textrm{ if }d = 1, \textrm{ and 0 otherwise}}{K = 1 if d=1, and 0 otherwise} controls the noise for higher dimensions.
}

\examples{
library(mgc)
result  <- mgc.sims.exp(n=100, d=10)  # simulate 100 samples in 10 dimensions
X <- result$X; Y <- result$Y
}
\author{
Eric Bridgeford
}
