% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGwasCatalog_function.R
\name{addGwasCatalog}
\alias{addGwasCatalog}
\title{Add GWAS data from NHGRI-EBI GWAS Catalog to list}
\usage{
addGwasCatalog(mgl, range = 0, download = TRUE, saveDownload = FALSE,
  fpsource = "./")
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{range}{Number indicating distance upstream of start and downstream of stop that should be used for filtering SNPs.}

\item{download}{A logical vector indicating if most recent version of the NHGRI-EBI GWAS Catalog should be downloaded.}

\item{saveDownload}{A logical vector indicating if the data should be saved as 'RawData_GwasCatalog.RData'}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}
}
\description{
\code{addGwasCatalog} returns a list with the eighteenth element as a dataframe with GWAS data from the NHGRI-EBI GWAS Catalog.
}
\details{
This gives basic information on trait associated variants as reported by the NHGRI-EBI GWAS Catalog for the gene of interest.  It pulls data based on the gene name and position (i.e. any SNP that falls between the start and stop position).  Note a wider range can be taken using the \emph{range} flag.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addGwasCatalog(myMgl, range = 0, download = TRUE, 
saveDownload = TRUE, fpsource = "./")}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGrasp}}, \code{\link{addLoc}},
  \code{\link{addPtv}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

