% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgwnbr.R
\name{mgwnbr}
\alias{mgwnbr}
\title{Multiscale Geographically Weighted Negative Binomial Regression}
\usage{
mgwnbr(
  data,
  formula,
  weight = NULL,
  lat,
  long,
  globalmin = TRUE,
  method,
  model = "negbin",
  mgwr = TRUE,
  bandwidth = "cv",
  offset = NULL,
  distancekm = FALSE,
  int = 50,
  h = NULL
)
}
\arguments{
\item{data}{name of the dataset.}

\item{formula}{regression model formula as in \code{lm}.}

\item{weight}{name of the variable containing the sample weights, default value is \code{NULL}.}

\item{lat}{name of the variable containing the latitudes in the dataset.}

\item{long}{name of the variable containing the longitudes in the dataset.}

\item{globalmin}{logical value indicating whether to find a global minimum in the optimization process, default value is \code{TRUE}.}

\item{method}{indicates the method to be used for the bandwidth calculation (\code{adaptive_bsq}, \code{fixed_bsq}, \code{fixed_g}).}

\item{model}{indicates the model to be used for the regression (\code{gaussian}, \code{poisson}, \code{negbin}, \code{logistic}), default value is\code{"negbin"}.}

\item{mgwr}{logical value indicating if multiscale should be used (\code{TRUE}, \code{FALSE}), default value is \code{TRUE}.}

\item{bandwidth}{indicates the criterion to be used for the bandwidth calculation (\code{cv}, \code{aic}), default value is \code{"cv"}.}

\item{offset}{name of the variable containing the offset values, if null then is set to a vector of zeros, default value is \code{NULL}.}

\item{distancekm}{logical value indicating whether to calculate the distances in km, default value is \code{FALSE}.}

\item{int}{integer indicating the number of iterations, default value is \code{50}.}

\item{h}{integer indicating a predetermined bandwidth value, default value is \code{NULL}.}
}
\value{
A list that contains:

\itemize{
\item \code{general_bandwidth} - General bandwidth value.
\item \code{band} - Bandwidth values for each covariate.
\item \code{measures} - Goodness of fit statistics.
\item \code{ENP} - Effective number of parameters.
\item \code{qntls_mgwr_param_estimates} - Quantiles of MGWR parameter estimates.
\item \code{descript_stats_mgwr_param_estimates} - Descriptive statistics of MGWR parameter estimates.
\item \code{p_values} - P-values for the t tests on parameter significance.
\item \code{t_critical} - Critical values for the t tests on parameter significance.
\item \code{qntls_mgwr_se} - Quantiles of MGWR standard errors.
\item \code{descript_stats_se} - Descriptive statistics of MGWR standard errors.
\item \code{global_param_estimates} - Parameter estimates for the global model.
\item \code{t_test_dfs} - Denominator degrees of freedom for the t tests.
\item \code{global_measures} - Goodness of fit statistics for the global model.
}
}
\description{
Fits a geographically weighted regression model with different scales for each covariate. Uses the negative binomial distribution as default, but also accepts the normal, Poisson, or logistic distributions. Can fit the global versions of each regression and also the geographically weighted alternatives with only one scale, since they are all particular cases of the multiscale approach.
}
\examples{
## Data


data(georgia)

for (var in c("PctFB", "PctBlack")){
  georgia[, var] <- as.data.frame(scale(georgia[, var]))
}


## Model

mod <- mgwnbr(data=georgia, formula=PctBach~PctBlack+PctFB,
 lat="Y", long="X", globalmin=FALSE, method="adaptive_bsq", bandwidth="cv",
  model="gaussian", mgwr=FALSE, h=136)

## Bandwidths
mod$general_bandwidth

## Goodness of fit measures
mod$measures

}
