% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_matrix.R
\name{proj_matrix}
\alias{proj_matrix}
\title{Variance-Covariance Matrix Projection}
\usage{
proj_matrix(VarRubin.matrix, metadata)
}
\arguments{
\item{VarRubin.matrix}{A variance-covariance matrix.}

\item{metadata}{Metadata of the experiment.}
}
\value{
A list of variance-covariance matrices.
}
\description{
Use a projection of the given variance-covariance matrix.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
VarRubin.matrix <- rubin2.all(datasim_imp[1:5,,],
attr(datasim,"metadata")$Condition)
proj_matrix(VarRubin.matrix, attr(datasim,"metadata"))
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
