% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invlogit_ci.R
\name{invlogit_ci}
\alias{invlogit_ci}
\title{Takes the inverse of logit transformed parameters and calculates
the confidence intervals}
\usage{
invlogit_ci(est, se, crit.value)
}
\arguments{
\item{est}{A parameter estimate on the logit scale.}

\item{se}{A standard error value on the logit scale.}

\item{crit.value}{Critical value of any distribution.}
}
\value{
Parameter, critical value and confidence
intervals on original scale.
}
\description{
\code{invlogit_ci} Takes the inverse of logit transformed
parameters and calculates the confidence interval
by using the critical value.
}
\details{
Takes the inverse of logit transformed parameter
estimates. The confidence interval is calculated by taking the
inverse of \eqn{est +/- crit.value{1-\alpha/2} * se}.
}
\examples{
 invlogit_ci(est=1.39, se=0.25, crit.value=1.96)

}
\author{
Martijn Heymans, 2021
}
